/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteType;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelProxyFactoryType;
import org.apache.camel.spring.CamelServiceExporterType;
import org.apache.camel.spring.EndpointFactoryBean;
import org.apache.camel.spring.RouteBuilderFinder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.SpringInstrumentationAgent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends IdentifiedType
implements RouteContainer,
FactoryBean,
InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private static final Log LOG = LogFactory.getLog(CamelContextFactoryBean.class);
    @XmlElement(name="package", required=false)
    private String[] packages = new String[0];
    @XmlElements(value={@XmlElement(name="beanPostProcessor", type=CamelBeanPostProcessor.class, required=false), @XmlElement(name="proxy", type=CamelProxyFactoryType.class, required=false), @XmlElement(name="export", type=CamelServiceExporterType.class, required=false)})
    private List beans;
    @XmlElement(name="endpoint", required=false)
    private List<EndpointFactoryBean> endpoints;
    @XmlElement(name="route", required=false)
    private List<RouteType> routes = new ArrayList<RouteType>();
    @XmlTransient
    private SpringCamelContext context;
    @XmlTransient
    private RouteBuilder routeBuilder;
    @XmlTransient
    private List<RouteBuilder> additionalBuilders = new ArrayList<RouteBuilder>();
    @XmlTransient
    private ApplicationContext applicationContext;

    public Object getObject() throws Exception {
        return this.getContext();
    }

    public Class getObjectType() {
        return SpringCamelContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.getContext();
        LOG.debug((Object)("Found JAXB created routes: " + this.getRoutes()));
        String[] names = this.applicationContext.getBeanNamesForType(SpringInstrumentationAgent.class);
        if (names.length == 1) {
            this.applicationContext.getBean(names[0], SpringInstrumentationAgent.class);
        }
        this.findRouteBuiders();
        this.installRoutes();
    }

    public void destroy() throws Exception {
        this.getContext().stop();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Publishing event: " + event));
        }
        if (event instanceof ContextRefreshedEvent) {
            try {
                LOG.debug((Object)"Starting the context now!");
                this.getContext().start();
            }
            catch (Exception e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
    }

    public SpringCamelContext getContext() throws Exception {
        if (this.context == null) {
            this.context = new SpringCamelContext(this.getApplicationContext());
        }
        return this.context;
    }

    public void setContext(SpringCamelContext context) {
        this.context = context;
    }

    public List<RouteType> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteType> routes) {
        this.routes = routes;
    }

    public RouteBuilder getRouteBuilder() {
        return this.routeBuilder;
    }

    public void setRouteBuilder(RouteBuilder routeBuilder) {
        this.routeBuilder = routeBuilder;
    }

    public void setRouteBuilders(RouteBuilder[] builders) {
        for (RouteBuilder builder : builders) {
            this.additionalBuilders.add(builder);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    protected void installRoutes() throws Exception {
        for (RouteBuilder routeBuilder : this.additionalBuilders) {
            this.getContext().addRoutes(routeBuilder);
        }
        if (this.routeBuilder != null) {
            this.getContext().addRoutes(this.routeBuilder);
        }
        for (RouteType route : this.routes) {
            route.addRoutes((CamelContext)this.getContext());
        }
    }

    protected void findRouteBuiders() throws Exception, InstantiationException {
        if (this.packages != null && this.packages.length > 0) {
            RouteBuilderFinder finder = new RouteBuilderFinder(this.getContext(), this.packages);
            finder.appendBuilders(this.additionalBuilders);
        }
    }
}

