/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.servlet.CamelHttpTransportServlet;
import org.apache.camel.component.servlet.CamelServletService;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletComponent
extends HttpComponent {
    private CamelServlet camelServlet;
    private CamelServletService camelServletService;

    public void setCamelServlet(CamelServlet servlet) {
        this.camelServlet = servlet;
    }

    public void setCamelServletService(CamelServletService service) {
        this.camelServletService = service;
    }

    public CamelServlet getCamelServlet(String servletName) {
        CamelServlet answer = this.camelServlet == null ? CamelHttpTransportServlet.getCamelServlet(servletName) : this.camelServlet;
        if (answer == null) {
            throw new IllegalArgumentException("Cannot find the deployed servlet, please configure the ServletComponent or configure a org.apache.camel.component.servlet.CamelHttpTransportServlet servlet in web.xml ");
        }
        return answer;
    }

    public CamelServletService getCamelServletService() {
        return this.camelServletService;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        uri = uri.startsWith("servlet:") ? remaining : uri;
        HttpClientParams params = new HttpClientParams();
        IntrospectionSupport.setProperties((Object)params, parameters, (String)"httpClient.");
        LinkedHashSet authMethods = new LinkedHashSet();
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, authMethods);
        Boolean throwExceptionOnFailure = (Boolean)this.getAndRemoveParameter(parameters, "throwExceptionOnFailure", Boolean.class);
        Boolean transferException = (Boolean)this.getAndRemoveParameter(parameters, "transferException", Boolean.class);
        Boolean bridgeEndpoint = (Boolean)this.getAndRemoveParameter(parameters, "bridgeEndpoint", Boolean.class);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        Boolean matchOnUriPrefix = (Boolean)this.getAndRemoveParameter(parameters, "matchOnUriPrefix", Boolean.class);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(UnsafeUriCharactersEncoder.encode((String)uri)), (Map)CastUtils.cast(parameters));
        uri = httpUri.toString();
        ServletEndpoint endpoint = this.createServletEndpoint(uri, this, httpUri, params, this.getHttpConnectionManager(), configurer);
        this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setBinding(binding);
        }
        if (throwExceptionOnFailure != null) {
            endpoint.setThrowExceptionOnFailure(throwExceptionOnFailure);
        }
        if (transferException != null) {
            endpoint.setTransferException(transferException);
        }
        if (bridgeEndpoint != null) {
            endpoint.setBridgeEndpoint(bridgeEndpoint);
        }
        if (matchOnUriPrefix != null) {
            endpoint.setMatchOnUriPrefix(matchOnUriPrefix);
        }
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected ServletEndpoint createServletEndpoint(String endpointUri, ServletComponent component, URI httpUri, HttpClientParams params, HttpConnectionManager httpConnectionManager, HttpClientConfigurer clientConfigurer) throws Exception {
        return new ServletEndpoint(endpointUri, component, httpUri, params, httpConnectionManager, clientConfigurer);
    }

    public void connect(HttpConsumer consumer) throws Exception {
        if (this.getCamelServletService() != null) {
            this.getCamelServletService().connect(consumer);
        } else {
            ServletEndpoint endpoint = (ServletEndpoint)consumer.getEndpoint();
            CamelServlet servlet = this.getCamelServlet(endpoint.getServletName());
            ObjectHelper.notNull((Object)servlet, (String)"CamelServlet");
            servlet.connect(consumer);
        }
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
        if (this.getCamelServletService() != null) {
            this.getCamelServletService().disconnect(consumer);
        } else {
            ServletEndpoint endpoint = (ServletEndpoint)consumer.getEndpoint();
            CamelServlet servlet = this.getCamelServlet(endpoint.getServletName());
            ObjectHelper.notNull((Object)servlet, (String)"CamelServlet");
            servlet.disconnect(consumer);
        }
    }
}

