/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class NettyComponent
extends UriEndpointComponent {
    private Timer timer;
    private NettyConfiguration configuration;
    private int maximumPoolSize = 16;
    private OrderedMemoryAwareThreadPoolExecutor executorService;

    public NettyComponent() {
        super(NettyEndpoint.class);
    }

    public NettyComponent(Class<? extends Endpoint> endpointClass) {
        super(endpointClass);
    }

    public NettyComponent(CamelContext context) {
        super(context, NettyEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HashMap options;
        NettyConfiguration config = this.configuration != null ? this.configuration.copy() : new NettyConfiguration();
        config = this.parseConfiguration(config, remaining, parameters);
        NettyServerBootstrapConfiguration bootstrapConfiguration = (NettyServerBootstrapConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "bootstrapConfiguration", NettyServerBootstrapConfiguration.class);
        if (bootstrapConfiguration != null && IntrospectionSupport.getProperties((Object)bootstrapConfiguration, options = new HashMap(), null, (boolean)false)) {
            IntrospectionSupport.setProperties((TypeConverter)this.getCamelContext().getTypeConverter(), (Object)config, options);
        }
        config.validateConfiguration();
        NettyEndpoint nettyEndpoint = new NettyEndpoint(remaining, this, config);
        nettyEndpoint.setTimer(this.getTimer());
        this.setProperties(nettyEndpoint.getConfiguration(), parameters);
        return nettyEndpoint;
    }

    protected NettyConfiguration parseConfiguration(NettyConfiguration configuration, String remaining, Map<String, Object> parameters) throws Exception {
        configuration.parseURI(new URI(remaining), parameters, this, "tcp", "udp");
        return configuration;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public synchronized OrderedMemoryAwareThreadPoolExecutor getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutorService();
        }
        return this.executorService;
    }

    protected void doStart() throws Exception {
        if (this.timer == null) {
            HashedWheelTimer hashedWheelTimer = new HashedWheelTimer();
            hashedWheelTimer.start();
            this.timer = hashedWheelTimer;
        }
        if (this.configuration == null) {
            this.configuration = new NettyConfiguration();
        }
        if (this.configuration.isOrderedThreadPoolExecutor()) {
            this.executorService = this.createExecutorService();
        }
        super.doStart();
    }

    protected OrderedMemoryAwareThreadPoolExecutor createExecutorService() {
        String pattern = this.getCamelContext().getExecutorServiceManager().getThreadNamePattern();
        CamelThreadFactory factory = new CamelThreadFactory(pattern, "NettyOrderedWorker", true);
        return new OrderedMemoryAwareThreadPoolExecutor(this.getMaximumPoolSize(), 0L, 0L, 30L, TimeUnit.SECONDS, (ThreadFactory)factory);
    }

    protected void doStop() throws Exception {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        if (this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow((ExecutorService)this.executorService);
            this.executorService = null;
        }
        super.doStop();
    }
}

