/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mina2.Mina2TextLineDelimiter;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;

public class Mina2Configuration
implements Cloneable {
    private String protocol;
    private String host;
    private int port;
    private boolean sync = true;
    private boolean textline;
    private Mina2TextLineDelimiter textlineDelimiter;
    private ProtocolCodecFactory codec;
    private String encoding;
    private long timeout = 30000L;
    private boolean lazySessionCreation = true;
    private boolean transferExchange;
    private boolean minaLogger;
    private int encoderMaxLineLength = -1;
    private int decoderMaxLineLength = -1;
    private List<IoFilter> filters;
    private boolean allowDefaultCodec = true;
    private boolean disconnect;
    private boolean disconnectOnNoReply = true;
    private LoggingLevel noReplyLogLevel = LoggingLevel.WARN;
    private SSLContextParameters sslContextParameters;
    private boolean autoStartTls = true;
    private int maximumPoolSize = 16;
    private boolean orderedThreadPoolExecutor = true;
    private boolean cachedAddress = true;

    public Mina2Configuration copy() {
        try {
            return (Mina2Configuration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getCharsetName() {
        if (this.encoding == null) {
            return null;
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding).name();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isTextline() {
        return this.textline;
    }

    public void setTextline(boolean textline) {
        this.textline = textline;
    }

    public Mina2TextLineDelimiter getTextlineDelimiter() {
        return this.textlineDelimiter;
    }

    public void setTextlineDelimiter(Mina2TextLineDelimiter textlineDelimiter) {
        this.textlineDelimiter = textlineDelimiter;
    }

    public ProtocolCodecFactory getCodec() {
        return this.codec;
    }

    public void setCodec(ProtocolCodecFactory codec) {
        this.codec = codec;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isLazySessionCreation() {
        return this.lazySessionCreation;
    }

    public void setLazySessionCreation(boolean lazySessionCreation) {
        this.lazySessionCreation = lazySessionCreation;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public void setEncoderMaxLineLength(int encoderMaxLineLength) {
        this.encoderMaxLineLength = encoderMaxLineLength;
    }

    public int getEncoderMaxLineLength() {
        return this.encoderMaxLineLength;
    }

    public void setDecoderMaxLineLength(int decoderMaxLineLength) {
        this.decoderMaxLineLength = decoderMaxLineLength;
    }

    public int getDecoderMaxLineLength() {
        return this.decoderMaxLineLength;
    }

    public boolean isMinaLogger() {
        return this.minaLogger;
    }

    public void setMinaLogger(boolean minaLogger) {
        this.minaLogger = minaLogger;
    }

    public List<IoFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<IoFilter> filters) {
        this.filters = filters;
    }

    public boolean isDatagramProtocol() {
        return this.protocol.equals("udp");
    }

    public void setAllowDefaultCodec(boolean allowDefaultCodec) {
        this.allowDefaultCodec = allowDefaultCodec;
    }

    public boolean isAllowDefaultCodec() {
        return this.allowDefaultCodec;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isDisconnectOnNoReply() {
        return this.disconnectOnNoReply;
    }

    public void setDisconnectOnNoReply(boolean disconnectOnNoReply) {
        this.disconnectOnNoReply = disconnectOnNoReply;
    }

    public LoggingLevel getNoReplyLogLevel() {
        return this.noReplyLogLevel;
    }

    public void setNoReplyLogLevel(LoggingLevel noReplyLogLevel) {
        this.noReplyLogLevel = noReplyLogLevel;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isAutoStartTls() {
        return this.autoStartTls;
    }

    public void setAutoStartTls(boolean autoStartTls) {
        this.autoStartTls = autoStartTls;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public boolean isOrderedThreadPoolExecutor() {
        return this.orderedThreadPoolExecutor;
    }

    public void setOrderedThreadPoolExecutor(boolean orderedThreadPoolExecutor) {
        this.orderedThreadPoolExecutor = orderedThreadPoolExecutor;
    }

    public void setCachedAddress(boolean shouldCacheAddress) {
        this.cachedAddress = shouldCacheAddress;
    }

    public boolean isCachedAddress() {
        return this.cachedAddress;
    }

    public String getUriString() {
        return "mina2:" + this.getProtocol() + ":" + this.getHost() + ":" + this.getPort();
    }
}

