/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedLogMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.LogProcessor;
import org.slf4j.Marker;

@ManagedResource(description="Managed Log")
public class ManagedLog
extends ManagedProcessor
implements ManagedLogMBean {
    private final LogProcessor processor;

    public ManagedLog(CamelContext context, LogProcessor processor, ProcessorDefinition<?> definition) {
        super(context, (Processor)processor, definition);
        this.processor = processor;
    }

    public String getMessage() {
        if (this.processor.getExpression() != null) {
            return this.processor.getExpression().toString();
        }
        return this.processor.getMessage();
    }

    public String getLoggingLevel() {
        LoggingLevel level = this.processor.getLogger().getLevel();
        return level != null ? level.name() : null;
    }

    public String getLogName() {
        return this.processor.getLogger().getLog().getName();
    }

    public String getMarker() {
        Marker marker = this.processor.getLogger().getMarker();
        return marker != null ? marker.getName() : null;
    }
}

