/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.main.MainShutdownStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMainShutdownStrategy
implements MainShutdownStrategy {
    protected static final Logger LOG = LoggerFactory.getLogger(SimpleMainShutdownStrategy.class);
    private final Set<MainShutdownStrategy.ShutdownEventListener> listeners = new LinkedHashSet<MainShutdownStrategy.ShutdownEventListener>();
    private final AtomicBoolean completed;
    private final AtomicBoolean timeoutEnabled = new AtomicBoolean();
    private final AtomicBoolean restarting = new AtomicBoolean();
    private volatile CountDownLatch latch;

    public SimpleMainShutdownStrategy() {
        this.completed = new AtomicBoolean();
        this.latch = new CountDownLatch(1);
    }

    @Override
    public boolean isRunAllowed() {
        return !this.completed.get();
    }

    @Override
    public void addShutdownListener(MainShutdownStrategy.ShutdownEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean shutdown() {
        if (this.completed.compareAndSet(false, true)) {
            LOG.debug("Shutdown called");
            this.latch.countDown();
            for (MainShutdownStrategy.ShutdownEventListener l : this.listeners) {
                try {
                    LOG.trace("ShutdownEventListener: {}", (Object)l);
                    l.onShutdown();
                }
                catch (Throwable e) {
                    LOG.debug("Error during ShutdownEventListener: {}. This exception is ignored.", (Object)l, (Object)e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void await() throws InterruptedException {
        LOG.debug("Await shutdown to complete");
        this.latch.await();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        boolean zero;
        this.timeoutEnabled.set(true);
        while (true) {
            LOG.debug("Await shutdown to complete with timeout: {} {}", (Object)timeout, (Object)unit);
            zero = this.latch.await(timeout, unit);
            if (!zero || !this.restarting.compareAndSet(true, false)) break;
            LOG.debug("Restarting await shutdown to complete with timeout: {} {}", (Object)timeout, (Object)unit);
            this.latch = new CountDownLatch(1);
        }
        return zero;
    }

    @Override
    public void restartAwait() {
        if (this.timeoutEnabled.get()) {
            LOG.trace("Restarting await with timeout");
            this.restarting.set(true);
            this.latch.countDown();
        }
    }
}

