/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Properties;
import org.apache.camel.util.TimeUtils;

public class TaskHealthState {
    private final boolean ready;
    private final boolean isTerminated;
    private final boolean isRecoverable;
    private final Exception lastError;
    private final String clientId;
    private final String bootstrapServers;
    private final long currentBackoffInterval;
    private final Properties clientProperties;

    public TaskHealthState(boolean ready, boolean isTerminated, boolean isRecoverable, Exception lastError, String clientId, long currentBackoffInterval, Properties clientProperties) {
        this.ready = ready;
        this.isTerminated = isTerminated;
        this.isRecoverable = isRecoverable;
        this.lastError = lastError;
        this.clientId = clientId;
        this.currentBackoffInterval = currentBackoffInterval;
        this.clientProperties = clientProperties;
        this.bootstrapServers = clientProperties.getProperty("bootstrap.servers");
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public boolean isRecoverable() {
        return this.isRecoverable;
    }

    public Exception getLastError() {
        return this.lastError;
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getCurrentBackoffInterval() {
        return this.currentBackoffInterval;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getGroupId() {
        return this.clientProperties.getProperty("group.id");
    }

    public String buildStateMessage() {
        Object msg = "KafkaConsumer is not ready";
        if (this.isTerminated()) {
            msg = (String)msg + " (gave up recovering and terminated the kafka consumer; restart route or application to recover).";
        } else if (this.isRecoverable()) {
            String time = TimeUtils.printDuration((long)this.getCurrentBackoffInterval(), (boolean)true);
            msg = (String)msg + " (recovery in progress using " + time + " intervals).";
        }
        return msg;
    }
}

