/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.transform;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.util.StringHelper;

public final class Json {
    private static final ObjectMapper MAPPER = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.READ_ENUMS_USING_TO_STRING})).enable(new SerializationFeature[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING})).disable(new JsonParser.Feature[]{JsonParser.Feature.AUTO_CLOSE_SOURCE})).enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES})).build()).setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_EMPTY, (JsonInclude.Include)JsonInclude.Include.NON_EMPTY));

    private Json() {
    }

    public static ObjectMapper mapper() {
        return MAPPER;
    }

    public static boolean isJson(String value) {
        if (value == null) {
            return false;
        }
        return Json.isJsonObject(value) || Json.isJsonArray(value);
    }

    public static boolean isJsonObject(String value) {
        if (value == null || value.isEmpty() || value.isBlank()) {
            return false;
        }
        String trimmed = value.trim();
        return trimmed.charAt(0) == '{' && trimmed.charAt(trimmed.length() - 1) == '}';
    }

    public static boolean isJsonArray(String value) {
        if (value == null || value.isEmpty() || value.isBlank()) {
            return false;
        }
        String trimmed = value.trim();
        return trimmed.charAt(0) == '[' && trimmed.charAt(trimmed.length() - 1) == ']';
    }

    public static List<String> arrayToJsonBeans(JsonNode json) throws JsonProcessingException {
        ArrayList<String> jsonBeans = new ArrayList<String>();
        if (json.isArray()) {
            Iterator it = json.elements();
            while (it.hasNext()) {
                Object item = it.next();
                if (item instanceof TextNode) {
                    jsonBeans.add(StringHelper.removeLeadingAndEndingQuotes((String)((TextNode)item).asText()));
                    continue;
                }
                jsonBeans.add(Json.mapper().writeValueAsString(item));
            }
            return jsonBeans;
        }
        return jsonBeans;
    }
}

