/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.impl;

import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Produce;
import org.apache.camel.guice.support.AnnotationMemberProvider;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.util.ObjectHelper;

public class ProduceInjector
extends CamelPostProcessorHelper
implements AnnotationMemberProvider<Produce> {
    @Inject
    public ProduceInjector(CamelContext camelContext) {
        super(camelContext);
    }

    @Override
    public boolean isNullParameterAllowed(Produce produce, Method method, Class<?> aClass, int index) {
        return false;
    }

    @Override
    public Object provide(Produce inject, TypeLiteral<?> typeLiteral, Field field) {
        Class<?> type = field.getType();
        String injectionPointName = field.getName();
        String endpointRef = inject.ref();
        String uri = inject.uri();
        String property = inject.property();
        return this.getInjectionValue(type, uri, endpointRef, property, injectionPointName, null, null);
    }

    @Override
    public Object provide(Produce inject, TypeLiteral<?> typeLiteral, Method method, Class<?> aClass, int index) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> type = parameterTypes[index];
        String injectionPointName = ObjectHelper.getPropertyName((Method)method);
        String endpointRef = inject.ref();
        String uri = inject.uri();
        String property = inject.property();
        return this.getInjectionValue(type, uri, endpointRef, property, injectionPointName, null, null);
    }
}

