/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileHelper;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockExclusiveReadLockStrategy
extends MarkerFileExclusiveReadLockStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FileLockExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 1000L;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.DEBUG;

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        if (!super.acquireExclusiveReadLock(operations, file, exchange)) {
            return false;
        }
        File target = new File(file.getAbsoluteFilePath());
        LOG.trace("Waiting for exclusive read lock to file: {}", (Object)target);
        FileChannel channel = null;
        RandomAccessFile randomAccessFile = null;
        boolean exclusive = false;
        FileLock lock = null;
        try {
            randomAccessFile = new RandomAccessFile(target, "rw");
            channel = randomAccessFile.getChannel();
            StopWatch watch = new StopWatch();
            while (!exclusive) {
                long delta2;
                if (this.timeout > 0L && (delta2 = watch.taken()) > this.timeout) {
                    CamelLogger.log((Logger)LOG, (LoggingLevel)this.readLockLoggingLevel, (String)("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + target));
                    boolean bl = false;
                    return bl;
                }
                if (!target.exists()) {
                    CamelLogger.log((Logger)LOG, (LoggingLevel)this.readLockLoggingLevel, (String)("Cannot acquire read lock as file no longer exists. Will skip the file: " + file));
                    boolean delta2 = false;
                    return delta2;
                }
                try {
                    lock = this.timeout > 0L ? channel.tryLock() : channel.lock();
                }
                catch (IllegalStateException delta2) {
                    // empty catch block
                }
                if (lock != null) {
                    LOG.trace("Acquired exclusive read lock: {} to file: {}", (Object)lock, (Object)target);
                    exclusive = true;
                    continue;
                }
                boolean interrupted = this.sleep();
                if (!interrupted) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            if (this.timeout == 0L) {
                boolean interrupted = false;
                return interrupted;
            }
            LOG.debug("Cannot acquire read lock. Will try again.", (Throwable)e);
            boolean interrupted = this.sleep();
            if (interrupted) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (!exclusive) {
                IOHelper.close((Closeable)channel, (String)("while acquiring exclusive read lock for file: " + target), (Logger)LOG);
                IOHelper.close((Closeable)randomAccessFile, (String)("while acquiring exclusive read lock for file: " + target), (Logger)LOG);
                super.releaseExclusiveReadLockOnAbort(operations, file, exchange);
            }
        }
        exchange.setProperty(GenericFileHelper.asExclusiveReadLockKey(file, "CamelFileLockExclusiveLock"), lock);
        exchange.setProperty(GenericFileHelper.asExclusiveReadLockKey(file, "CamelFileLockRandomAccessFile"), (Object)randomAccessFile);
        exchange.setProperty(GenericFileHelper.asExclusiveReadLockKey(file, "CamelFileLockChannelFile"), (Object)channel);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReleaseExclusiveReadLock(GenericFile<File> file, Exchange exchange) throws Exception {
        super.doReleaseExclusiveReadLock(file, exchange);
        FileLock lock = (FileLock)exchange.getProperty(GenericFileHelper.asExclusiveReadLockKey(file, "CamelFileLockExclusiveLock"), FileLock.class);
        RandomAccessFile rac = (RandomAccessFile)exchange.getProperty(GenericFileHelper.asExclusiveReadLockKey(file, "CamelFileLockExclusiveLock"), RandomAccessFile.class);
        Channel channel = (Channel)exchange.getProperty(GenericFileHelper.asExclusiveReadLockKey(file, "CamelFileLockChannelFile"), FileChannel.class);
        String target = file.getFileName();
        if (lock != null) {
            channel = lock.acquiredBy() != null ? lock.acquiredBy() : channel;
            try (FileLock fileLock = lock;){
                fileLock.release();
            }
            finally {
                IOHelper.close((Closeable)channel, (String)("while releasing exclusive read lock for file: " + target), (Logger)LOG);
                IOHelper.close((Closeable)rac, (String)("while releasing exclusive read lock for file: " + target), (Logger)LOG);
            }
        }
    }

    private boolean sleep() {
        LOG.trace("Exclusive read lock not granted. Sleeping for {} millis.", (Object)this.checkInterval);
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    @Override
    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }
}

