/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.component.ehcache.EhcacheEndpoint;
import org.apache.camel.component.ehcache.EhcacheManager;
import org.apache.camel.impl.DefaultProducer;
import org.ehcache.Cache;

public class EhcacheProducer
extends DefaultProducer {
    private final EhcacheConfiguration configuration;
    private final EhcacheManager manager;
    private final Cache cache;

    public EhcacheProducer(EhcacheEndpoint endpoint, EhcacheConfiguration configuration) throws Exception {
        super((Endpoint)endpoint);
        this.configuration = configuration;
        this.manager = endpoint.getManager();
        this.cache = this.manager.getCache();
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        String action = (String)exchange.getIn().getHeader("CamelEhcacheAction", (Object)this.configuration.getAction(), String.class);
        if (action == null) {
            throw new NoSuchHeaderException(exchange, "CamelEhcacheAction", String.class);
        }
        switch (action) {
            case "CLEAR": {
                this.onClear(message);
                break;
            }
            case "PUT": {
                this.onPut(message);
                break;
            }
            case "PUT_ALL": {
                this.onPutAll(message);
                break;
            }
            case "PUT_IF_ABSENT": {
                this.onPutIfAbsent(message);
                break;
            }
            case "GET": {
                this.onGet(message);
                break;
            }
            case "GET_ALL": {
                this.onGetAll(message);
                break;
            }
            case "REMOVE": {
                this.onRemove(message);
                break;
            }
            case "REMOVE_ALL": {
                this.onRemoveAll(message);
                break;
            }
            case "REPLACE": {
                this.onReplace(message);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operation " + action);
            }
        }
    }

    private void onClear(Message message) throws Exception {
        this.cache.clear();
        this.setResult(message, true, null, null);
    }

    private void onPut(Message message) throws Exception {
        this.cache.put(this.getKey(message), this.getValue(message, this.configuration.getValueType()));
        this.setResult(message, true, null, null);
    }

    private void onPutAll(Message message) throws Exception {
        this.cache.putAll((Map)this.getValue(message, Map.class));
        this.setResult(message, true, null, null);
    }

    private void onPutIfAbsent(Message message) throws Exception {
        Object oldValue = this.cache.putIfAbsent(this.getKey(message), this.getValue(message, this.configuration.getValueType()));
        this.setResult(message, true, null, oldValue);
    }

    private void onGet(Message message) throws Exception {
        Object result = this.cache.get(this.getKey(message));
        this.setResult(message, true, result, null);
    }

    private void onGetAll(Message message) throws Exception {
        Map result = this.cache.getAll((Set)message.getHeader("CamelEhcacheKeys", Set.class));
        this.setResult(message, true, result, null);
    }

    private void onRemove(Message message) throws Exception {
        boolean success = true;
        Object valueToReplace = message.getHeader("CamelEhcacheOldValue");
        if (valueToReplace == null) {
            this.cache.remove(this.getKey(message));
        } else {
            success = this.cache.remove(this.getKey(message), valueToReplace);
        }
        this.setResult(message, success, null, null);
    }

    private void onRemoveAll(Message message) throws Exception {
        this.cache.removeAll((Set)message.getHeader("CamelEhcacheKeys", Set.class));
        this.setResult(message, true, null, null);
    }

    private void onReplace(Message message) throws Exception {
        boolean success = true;
        Object oldValue = null;
        Object value = this.getValue(message, this.configuration.getValueType());
        Object valueToReplace = message.getHeader("CamelEhcacheOldValue");
        if (valueToReplace == null) {
            oldValue = this.cache.replace(this.getKey(message), value);
        } else {
            success = this.cache.replace(this.getKey(message), valueToReplace, value);
        }
        this.setResult(message, success, null, oldValue);
    }

    private Object getKey(Message message) throws Exception {
        Object value = message.getHeader("CamelEhcacheKey", this.configuration.getKeyType());
        if (value == null) {
            value = this.configuration.getKey();
        }
        if (value == null) {
            throw new CamelExchangeException("No value provided in header or as default value (CamelEhcacheKey)", message.getExchange());
        }
        return value;
    }

    private Object getValue(Message message, Class<?> type) throws Exception {
        Object value = message.getHeader("CamelEhcacheValue", type);
        if (value == null) {
            value = message.getBody(type);
        }
        if (value == null) {
            throw new CamelExchangeException("No value provided in header or body (CamelEhcacheValue)", message.getExchange());
        }
        return value;
    }

    private void setResult(Message message, boolean success, Object result, Object oldValue) {
        message.setHeader("CamelEhcacheActionSucceeded", (Object)success);
        message.setHeader("CamelEhcacheActionHasResult", (Object)(oldValue != null || result != null ? 1 : 0));
        if (oldValue != null) {
            message.setHeader("CamelEhcacheOldValue", oldValue);
        }
        if (result != null) {
            message.setBody(result);
        }
    }
}

