/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.io.IOException;
import org.apache.camel.Service;
import org.apache.camel.component.ehcache.EhcacheConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheManager
implements Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheManager.class);
    private final EhcacheConfiguration configuration;
    private final CacheManager cacheManager;
    private final boolean managed;

    public EhcacheManager(EhcacheConfiguration configuration) throws IOException {
        this(configuration.createCacheManager(), !configuration.hasCacheManager(), configuration);
    }

    public EhcacheManager(CacheManager cacheManager) {
        this(cacheManager, false, null);
    }

    public EhcacheManager(CacheManager cacheManager, boolean managed) {
        this(cacheManager, managed, null);
    }

    private EhcacheManager(CacheManager cacheManager, boolean managed, EhcacheConfiguration configuration) {
        this.cacheManager = cacheManager;
        this.managed = managed;
        this.configuration = configuration;
        ObjectHelper.notNull((Object)cacheManager, (String)"cacheManager");
    }

    public void start() throws Exception {
        if (this.managed) {
            this.cacheManager.init();
        }
    }

    public void stop() throws Exception {
        if (this.managed) {
            this.cacheManager.close();
        }
    }

    public <K, V> Cache<K, V> getCache(String name, Class<K> keyType, Class<V> valueType) throws Exception {
        Cache cache = this.cacheManager.getCache(name, keyType, valueType);
        if (cache == null && this.configuration != null && this.configuration.isCreateCacheIfNotExist()) {
            cache = this.cacheManager.createCache(name, this.configuration.getMandatoryConfiguration());
        }
        return cache;
    }

    public Cache<?, ?> getCache(String name) throws Exception {
        return this.getCache(name, this.configuration.getKeyType(), this.configuration.getValueType());
    }

    public Cache<?, ?> getCache() throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"Ehcache configuration");
        return this.getCache(this.configuration.getCacheName(), this.configuration.getKeyType(), this.configuration.getValueType());
    }
}

