/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache;

import java.io.IOException;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.xml.XmlConfiguration;

@UriParams
public class EhcacheConfiguration {
    public static final String PREFIX_CONF = "conf.";
    public static final String PREFIX_POOL = "pool.";
    private final CamelContext context;
    private final String cacheName;
    @UriParam
    private String configUri;
    @UriParam(defaultValue="true")
    private boolean createCacheIfNotExist = true;
    @UriParam(label="producer")
    private String action;
    @UriParam(label="producer")
    private Object key;
    @UriParam
    private CacheManager cacheManager;
    @UriParam(label="advanced")
    private CacheConfiguration<?, ?> configuration;
    @UriParam(label="advanced", javaType="java.lang.String", defaultValue="java.lang.Object")
    private Class<?> keyType = Object.class;
    @UriParam(label="advanced", javaType="java.lang.String", defaultValue="java.lang.Object")
    private Class<?> valueType = Object.class;
    @UriParam(label="consumer", enums="ORDERED,UNORDERED", defaultValue="ORDERED")
    private EventOrdering eventOrdering = EventOrdering.ORDERED;
    @UriParam(label="consumer", enums="ASYNCHRONOUS,SYNCHRONOUS", defaultValue="ASYNCHRONOUS")
    private EventFiring eventFiring = EventFiring.ASYNCHRONOUS;
    @UriParam(label="consumer", enums="EVICTED,EXPIRED,REMOVED,CREATED,UPDATED", defaultValue="EVICTED,EXPIRED,REMOVED,CREATED,UPDATED")
    private Set<EventType> eventTypes = EnumSet.of(EventType.values()[0], EventType.values());

    EhcacheConfiguration(String cacheName) {
        this(null, cacheName);
    }

    EhcacheConfiguration(CamelContext context, String cacheName) {
        this.context = context;
        this.cacheName = cacheName;
        Stream.of(EventType.values()).map(Enum::name).collect(Collectors.joining(", "));
    }

    public CamelContext getContext() {
        return this.context;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getConfigUri() {
        return this.configUri;
    }

    public URL getConfigUriAsUrl() throws IOException {
        return this.context != null ? ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)this.context.getClassResolver(), (String)this.configUri) : new URL(this.configUri);
    }

    public void setConfigUri(String configUri) {
        this.configUri = configUri;
    }

    public boolean isCreateCacheIfNotExist() {
        return this.createCacheIfNotExist;
    }

    public void setCreateCacheIfNotExist(boolean createCacheIfNotExist) {
        this.createCacheIfNotExist = createCacheIfNotExist;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public boolean hasCacheManager() {
        return this.cacheManager != null;
    }

    public EventOrdering getEventOrdering() {
        return this.eventOrdering;
    }

    public void setEventOrdering(String eventOrdering) {
        this.setEventOrdering(EventOrdering.valueOf((String)eventOrdering));
    }

    public void setEventOrdering(EventOrdering eventOrdering) {
        this.eventOrdering = eventOrdering;
    }

    public EventFiring getEventFiring() {
        return this.eventFiring;
    }

    public void setEventFiring(String eventFiring) {
        this.setEventFiring(EventFiring.valueOf((String)eventFiring));
    }

    public void setEventFiring(EventFiring eventFiring) {
        this.eventFiring = eventFiring;
    }

    public Set<EventType> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(String eventTypesString) {
        String[] events;
        HashSet<EventType> eventTypes = new HashSet<EventType>();
        for (String event : events = eventTypesString.split(",")) {
            eventTypes.add(EventType.valueOf((String)event));
        }
        this.setEventTypes(eventTypes);
    }

    public void setEventTypes(Set<EventType> eventTypes) {
        this.eventTypes = new HashSet<EventType>(eventTypes);
    }

    public <K, V> void setConfiguration(CacheConfiguration<K, V> configuration) {
        this.configuration = configuration;
    }

    public <K, V> CacheConfiguration<K, V> getConfiguration() {
        return this.configuration;
    }

    public <K, V> CacheConfiguration<K, V> getMandatoryConfiguration() {
        return (CacheConfiguration)ObjectHelper.notNull(this.getConfiguration(), (String)"CacheConfiguration");
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }

    public void setKeyType(Class<?> keyType) {
        this.keyType = keyType;
    }

    public void setKeyType(String keyType) throws ClassNotFoundException {
        this.setKeyType(this.context.getClassResolver().resolveMandatoryClass(keyType));
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public void setValueType(Class<?> valueType) {
        this.valueType = valueType;
    }

    public void setValueType(String valueType) throws ClassNotFoundException {
        this.setValueType(this.context.getClassResolver().resolveMandatoryClass(valueType));
    }

    static EhcacheConfiguration create(CamelContext context, String remaining, Map<String, Object> parameters) throws Exception {
        EhcacheConfiguration configuration = new EhcacheConfiguration(context, remaining);
        EndpointHelper.setReferenceProperties((CamelContext)context, (Object)configuration, parameters);
        EndpointHelper.setProperties((CamelContext)context, (Object)configuration, parameters);
        return configuration;
    }

    CacheManager createCacheManager() throws IOException {
        CacheManager manager;
        if (this.cacheManager != null) {
            manager = this.cacheManager;
        } else if (this.configUri != null) {
            manager = CacheManagerBuilder.newCacheManager((Configuration)new XmlConfiguration(this.getConfigUriAsUrl()));
        } else {
            CacheManagerBuilder builder = CacheManagerBuilder.newCacheManagerBuilder();
            if (this.configuration != null) {
                builder.withCache(this.cacheName, this.configuration);
            }
            manager = builder.build();
        }
        return manager;
    }
}

