/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfClientCallback
extends ClientCallback {
    private static final Log LOG = LogFactory.getLog(CxfClientCallback.class);
    private final AsyncCallback camelAsyncCallback;
    private final Exchange camelExchange;
    private final org.apache.cxf.message.Exchange cxfExchange;
    private final BindingOperationInfo boi;
    private final CxfEndpoint endpoint;

    public CxfClientCallback(AsyncCallback callback, Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange, BindingOperationInfo boi, CxfEndpoint endpoint) {
        this.camelAsyncCallback = callback;
        this.camelExchange = camelExchange;
        this.cxfExchange = cxfExchange;
        this.boi = boi;
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(Map<String, Object> ctx, Object[] res) {
        try {
            super.handleResponse(ctx, res);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!this.boi.getOperationInfo().isOneWay()) {
                this.camelExchange.getOut().getHeaders().putAll(this.camelExchange.getIn().getHeaders());
                this.endpoint.getCxfBinding().populateExchangeFromCxfResponse(this.camelExchange, this.cxfExchange, ctx);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(Thread.currentThread().getName() + " calling handleResponse"));
            }
            this.camelAsyncCallback.done(false);
            throw throwable;
        }
        if (!this.boi.getOperationInfo().isOneWay()) {
            this.camelExchange.getOut().getHeaders().putAll(this.camelExchange.getIn().getHeaders());
            this.endpoint.getCxfBinding().populateExchangeFromCxfResponse(this.camelExchange, this.cxfExchange, ctx);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Thread.currentThread().getName() + " calling handleResponse"));
        }
        this.camelAsyncCallback.done(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Map<String, Object> ctx, Throwable ex) {
        try {
            super.handleException(ctx, ex);
            this.camelExchange.setException(ex);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!this.boi.getOperationInfo().isOneWay()) {
                this.camelExchange.getOut().getHeaders().putAll(this.camelExchange.getIn().getHeaders());
                this.endpoint.getCxfBinding().populateExchangeFromCxfResponse(this.camelExchange, this.cxfExchange, ctx);
                this.camelExchange.getOut().setFault(true);
                this.camelExchange.getOut().setBody((Object)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(Thread.currentThread().getName() + " calling handleException"));
            }
            this.camelAsyncCallback.done(false);
            throw throwable;
        }
        if (!this.boi.getOperationInfo().isOneWay()) {
            this.camelExchange.getOut().getHeaders().putAll(this.camelExchange.getIn().getHeaders());
            this.endpoint.getCxfBinding().populateExchangeFromCxfResponse(this.camelExchange, this.cxfExchange, ctx);
            this.camelExchange.getOut().setFault(true);
            this.camelExchange.getOut().setBody((Object)ex);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Thread.currentThread().getName() + " calling handleException"));
        }
        this.camelAsyncCallback.done(false);
    }
}

