/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.atomix.Atomix;
import io.atomix.catalyst.transport.Address;
import io.atomix.resource.ReadConsistency;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.atomix.client.set.AtomixSet;
import org.apache.camel.component.atomix.client.set.AtomixSetComponent;
import org.apache.camel.component.atomix.client.set.AtomixSetConfiguration;

public interface AtomixSetComponentBuilderFactory {
    public static AtomixSetComponentBuilder atomixSet() {
        return new AtomixSetComponentBuilderImpl();
    }

    public static class AtomixSetComponentBuilderImpl
    extends AbstractComponentBuilder<AtomixSetComponent>
    implements AtomixSetComponentBuilder {
        @Override
        protected AtomixSetComponent buildConcreteComponent() {
            return new AtomixSetComponent();
        }

        private AtomixSetConfiguration getOrCreateConfiguration(AtomixSetComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new AtomixSetConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "atomix": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setAtomix((Atomix)value);
                    return true;
                }
                case "configuration": {
                    ((AtomixSetComponent)component).setConfiguration((AtomixSetConfiguration)value);
                    return true;
                }
                case "configurationUri": {
                    ((AtomixSetComponent)component).setConfigurationUri((String)value);
                    return true;
                }
                case "defaultAction": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setDefaultAction((AtomixSet.Action)value);
                    return true;
                }
                case "nodes": {
                    ((AtomixSetComponent)component).setNodes((List)value);
                    return true;
                }
                case "resultHeader": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setResultHeader((String)value);
                    return true;
                }
                case "transportClassName": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setTransportClassName((String)value);
                    return true;
                }
                case "ttl": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setTtl(((Long)value).longValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((AtomixSetComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((AtomixSetComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((AtomixSetComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "defaultResourceConfig": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setDefaultResourceConfig((Properties)value);
                    return true;
                }
                case "defaultResourceOptions": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setDefaultResourceOptions((Properties)value);
                    return true;
                }
                case "ephemeral": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setEphemeral(((Boolean)value).booleanValue());
                    return true;
                }
                case "readConsistency": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setReadConsistency((ReadConsistency)value);
                    return true;
                }
                case "resourceConfigs": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setResourceConfigs((Map)value);
                    return true;
                }
                case "resourceOptions": {
                    this.getOrCreateConfiguration((AtomixSetComponent)component).setResourceOptions((Map)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AtomixSetComponentBuilder
    extends ComponentBuilder<AtomixSetComponent> {
        default public AtomixSetComponentBuilder atomix(Atomix atomix) {
            this.doSetProperty("atomix", atomix);
            return this;
        }

        default public AtomixSetComponentBuilder configuration(AtomixSetConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AtomixSetComponentBuilder configurationUri(String configurationUri) {
            this.doSetProperty("configurationUri", configurationUri);
            return this;
        }

        default public AtomixSetComponentBuilder defaultAction(AtomixSet.Action defaultAction) {
            this.doSetProperty("defaultAction", defaultAction);
            return this;
        }

        default public AtomixSetComponentBuilder nodes(List<Address> nodes) {
            this.doSetProperty("nodes", nodes);
            return this;
        }

        default public AtomixSetComponentBuilder resultHeader(String resultHeader) {
            this.doSetProperty("resultHeader", resultHeader);
            return this;
        }

        default public AtomixSetComponentBuilder transportClassName(String transportClassName) {
            this.doSetProperty("transportClassName", transportClassName);
            return this;
        }

        default public AtomixSetComponentBuilder ttl(long ttl) {
            this.doSetProperty("ttl", ttl);
            return this;
        }

        default public AtomixSetComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AtomixSetComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AtomixSetComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AtomixSetComponentBuilder defaultResourceConfig(Properties defaultResourceConfig) {
            this.doSetProperty("defaultResourceConfig", defaultResourceConfig);
            return this;
        }

        default public AtomixSetComponentBuilder defaultResourceOptions(Properties defaultResourceOptions) {
            this.doSetProperty("defaultResourceOptions", defaultResourceOptions);
            return this;
        }

        default public AtomixSetComponentBuilder ephemeral(boolean ephemeral) {
            this.doSetProperty("ephemeral", ephemeral);
            return this;
        }

        default public AtomixSetComponentBuilder readConsistency(ReadConsistency readConsistency) {
            this.doSetProperty("readConsistency", readConsistency);
            return this;
        }

        default public AtomixSetComponentBuilder resourceConfigs(Map<String, Properties> resourceConfigs) {
            this.doSetProperty("resourceConfigs", resourceConfigs);
            return this;
        }

        default public AtomixSetComponentBuilder resourceOptions(Map<String, Properties> resourceOptions) {
            this.doSetProperty("resourceOptions", resourceOptions);
            return this;
        }
    }
}

