/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake;

import com.azure.core.http.HttpHeaders;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.models.AccessTier;
import com.azure.storage.file.datalake.models.ArchiveStatus;
import com.azure.storage.file.datalake.models.CopyStatusType;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.FileQueryError;
import com.azure.storage.file.datalake.models.FileQueryProgress;
import com.azure.storage.file.datalake.models.FileQuerySerialization;
import com.azure.storage.file.datalake.models.FileRange;
import com.azure.storage.file.datalake.models.FileReadHeaders;
import com.azure.storage.file.datalake.models.LeaseDurationType;
import com.azure.storage.file.datalake.models.LeaseStateType;
import com.azure.storage.file.datalake.models.LeaseStatusType;
import com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathProperties;
import com.azure.storage.file.datalake.models.PublicAccessType;
import com.azure.storage.file.datalake.options.FileQueryOptions;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition;
import org.apache.camel.util.ObjectHelper;

public class DataLakeExchangeHeaders {
    private final Map<String, Object> headers = new HashMap<String, Object>();

    public static DataLakeExchangeHeaders createDataLakeExchangeHeadersFromPathProperties(PathProperties properties) {
        return new DataLakeExchangeHeaders().accessTier(properties.getAccessTier()).accessTierChangrTime(properties.getAccessTierChangeTime()).archiveStatus(properties.getArchiveStatus()).cacheControl(properties.getCacheControl()).contentDisposition(properties.getContentDisposition()).contentEncoding(properties.getContentEncoding()).contentLanguage(properties.getContentLanguage()).contentMd5(properties.getContentMd5()).contentType(properties.getContentType()).copyCompletionTime(properties.getCopyCompletionTime()).copyId(properties.getCopyId()).copyProgress(properties.getCopyProgress()).copySource(properties.getCopySource()).copyStatus(properties.getCopyStatus()).copyStatusDescription(properties.getCopyStatusDescription()).creationTime(properties.getCreationTime()).encryptionKeySha256(properties.getEncryptionKeySha256()).eTag(properties.getETag()).fileSize(properties.getFileSize()).lastModified(properties.getLastModified()).leaseDuration(properties.getLeaseDuration()).leaseState(properties.getLeaseState()).leaseStatus(properties.getLeaseStatus()).metadata(properties.getMetadata()).incrementalCopy(properties.isIncrementalCopy()).serverEncrypted(properties.isServerEncrypted());
    }

    public static DataLakeExchangeHeaders createDataLakeExchangeHeadersFromPathInfo(PathInfo pathInfo) {
        return new DataLakeExchangeHeaders().eTag(pathInfo.getETag()).lastModified(pathInfo.getLastModified());
    }

    public static DataLakeExchangeHeaders createDataLakeExchangeHeadersFromFileReadHeaders(FileReadHeaders fileReadHeaders) {
        return DataLakeExchangeHeaders.createDataLakeExchangeHeadersFromPathProperties(DataLakeExchangeHeaders.buildPathProperties(fileReadHeaders));
    }

    private static PathProperties buildPathProperties(FileReadHeaders rh) {
        long contentLength = rh.getContentLength() == null ? 0L : rh.getContentLength();
        return new PathProperties(null, rh.getLastModified(), rh.getETag(), contentLength, rh.getContentType(), null, rh.getContentEncoding(), rh.getContentDisposition(), rh.getContentLanguage(), rh.getCacheControl(), rh.getLeaseStatus(), rh.getLeaseState(), rh.getLeaseDuration(), rh.getCopyId(), rh.getCopyStatus(), rh.getCopySource(), rh.getCopyProgress(), rh.getCopyCompletionTime(), rh.getCopyStatusDescription(), rh.isServerEncrypted(), null, null, null, rh.getEncryptionKeySha256(), null, rh.getMetadata());
    }

    public static ListFileSystemsOptions getListFileSystemOptionsFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeListFileSystemsOptions", ListFileSystemsOptions.class);
    }

    public static DataLakeExchangeHeaders create() {
        return new DataLakeExchangeHeaders();
    }

    public static Duration getTimoutFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeTimeout", Duration.class);
    }

    public static DataLakeOperationsDefinition getDataLakeOperationsDefinitionFromHeader(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeOperation", DataLakeOperationsDefinition.class);
    }

    public static String getFileSystemNameFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeFileSystemName", String.class);
    }

    public static String getDirectoryNameFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeDirectoryName", String.class);
    }

    public static String getFileNameFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeFileName", String.class);
    }

    public static Map<String, String> getMedataFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeMetadata", Map.class);
    }

    public static PublicAccessType getPublicAccessTypeFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakePublicAccessType", PublicAccessType.class);
    }

    public static DataLakeRequestConditions getDataLakeRequestConditionsFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeRequestCondition", DataLakeRequestConditions.class);
    }

    public static ListPathsOptions getListPathsOptionsFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeListPathOptions", ListPathsOptions.class);
    }

    public static String getPathFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakePath", String.class);
    }

    public static Boolean getRecursiveFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeRecursive", Boolean.class);
    }

    public static Integer getMaxResultsFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeMaxResults", Integer.class);
    }

    public static Boolean getUserPrincipalNameReturnedFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeUserPrincipalNameReturned", Boolean.class);
    }

    public static String getRegexFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeRegex", String.class);
    }

    public static String getFileDirFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeFileDir", String.class);
    }

    public static AccessTier getAccessTierFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeAccessTier", AccessTier.class);
    }

    public static byte[] getContendMd5FromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeContentMD5", byte[].class);
    }

    public static FileRange getFileRangeFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeFileRange", FileRange.class);
    }

    public static ParallelTransferOptions getParallelTransferOptionsFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeParallelTransferOptions", ParallelTransferOptions.class);
    }

    public static Set<OpenOption> getOpenOptionsFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeOpenOptions", Set.class);
    }

    public static Long getDownloadLinkExpirationFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeDownloadLinkExpiration", Long.class);
    }

    public static Long getFileOffsetFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeFileOffset", Long.class);
    }

    public static String getLeaseIdFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeLeaseId", String.class);
    }

    public static PathHttpHeaders getPathHttpHeadersFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakePathHttpHeaders", PathHttpHeaders.class);
    }

    public static Boolean getRetainUncommittedDataFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeRetainCommitedData", Boolean.class);
    }

    public static Boolean getCloseFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeClose", Boolean.class);
    }

    public static Long getPositionFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakePosition", Long.class);
    }

    public static String getExpressionFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeExpression", String.class);
    }

    public static FileQuerySerialization getInputSerializationFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeInputSerialization", FileQuerySerialization.class);
    }

    public static FileQuerySerialization getOutputSerializationFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeOutputSerialization", FileQuerySerialization.class);
    }

    public static Consumer<FileQueryError> getErrorConsumerFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeErrorConsumer", Consumer.class);
    }

    public static Consumer<FileQueryProgress> getProgressConsumerFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeProgressConsumer", Consumer.class);
    }

    public static FileQueryOptions getQueryOptionsFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeQueryOptions", FileQueryOptions.class);
    }

    public static String getPermissionFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakePermission", String.class);
    }

    public static String getUmaskFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeUmask", String.class);
    }

    public static DataLakeFileClient getFileClientFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeFileClient", DataLakeFileClient.class);
    }

    public static Boolean getFlushFromHeaders(Exchange exchange) {
        return DataLakeExchangeHeaders.getObjectFromHeaders(exchange, "CamelAzureStorageDataLakeFlush", Boolean.class);
    }

    private static <T> T getObjectFromHeaders(Exchange exchange, String headerName, Class<T> classType) {
        return (T)(ObjectHelper.isEmpty((Object)exchange) ? null : exchange.getIn().getHeader(headerName, classType));
    }

    public Map<String, Object> toMap() {
        return this.headers;
    }

    public DataLakeExchangeHeaders httpHeaders(HttpHeaders httpHeaders) {
        this.headers.put("CamelAzureStorageDataLakeRawHttpHeaders", httpHeaders);
        return this;
    }

    public DataLakeExchangeHeaders accessTier(AccessTier accessTier) {
        this.headers.put("CamelAzureStorageDataLakeAccessTier", accessTier);
        return this;
    }

    public DataLakeExchangeHeaders accessTierChangrTime(OffsetDateTime accessTierChangeTime) {
        this.headers.put("CamelAzureStorageDataLakeAccessTierChangeTime", accessTierChangeTime);
        return this;
    }

    public DataLakeExchangeHeaders archiveStatus(ArchiveStatus archiveStatus) {
        this.headers.put("CamelAzureStorageDataLakeArchiveStatus", archiveStatus);
        return this;
    }

    public DataLakeExchangeHeaders cacheControl(String cacheControl) {
        this.headers.put("CamelAzureStorageDataLakeCacheControl", cacheControl);
        return this;
    }

    public DataLakeExchangeHeaders contentDisposition(String contentDisposition) {
        this.headers.put("CamelAzureStorageDataLakeContentDisposition", contentDisposition);
        return this;
    }

    public DataLakeExchangeHeaders contentEncoding(String contentEncoding) {
        this.headers.put("CamelAzureStorageDataLakeContentEncoding", contentEncoding);
        return this;
    }

    public DataLakeExchangeHeaders contentLanguage(String contentLanguage) {
        this.headers.put("CamelAzureStorageDataLakeContentLanguage", contentLanguage);
        return this;
    }

    public DataLakeExchangeHeaders contentMd5(byte[] contentMd5) {
        this.headers.put("CamelAzureStorageDataLakeContentMD5", contentMd5);
        return this;
    }

    public DataLakeExchangeHeaders contentType(String contentType) {
        this.headers.put("CamelAzureStorageDataLakeContentType", contentType);
        return this;
    }

    public DataLakeExchangeHeaders copyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.headers.put("CamelAzureStorageDataLakeCopyCompletionTime", copyCompletionTime);
        return this;
    }

    public DataLakeExchangeHeaders copyId(String copyId) {
        this.headers.put("CamelAzureStorageDataLakeCopyId", copyId);
        return this;
    }

    public DataLakeExchangeHeaders copyProgress(String copyProgress) {
        this.headers.put("CamelAzureStorageDataLakeCopyProgress", copyProgress);
        return this;
    }

    public DataLakeExchangeHeaders copySource(String copySource) {
        this.headers.put("CamelAzureStorageDataLakeCopySource", copySource);
        return this;
    }

    public DataLakeExchangeHeaders copyStatus(CopyStatusType copyStatus) {
        this.headers.put("CamelAzureStorageDataLakeCopyStatus", copyStatus);
        return this;
    }

    public DataLakeExchangeHeaders copyStatusDescription(String copyStatusDescription) {
        this.headers.put("CamelAzureStorageDataLakeCopyStatusDescription", copyStatusDescription);
        return this;
    }

    public DataLakeExchangeHeaders creationTime(OffsetDateTime creationTime) {
        this.headers.put("CamelAzureStorageDataLakeCreationTime", creationTime);
        return this;
    }

    public DataLakeExchangeHeaders encryptionKeySha256(String key) {
        this.headers.put("CamelAzureStorageDataLakeEncryptionKeySha256", key);
        return this;
    }

    public DataLakeExchangeHeaders eTag(String eTag) {
        this.headers.put("CamelAzureStorageDataLakeETag", eTag);
        return this;
    }

    public DataLakeExchangeHeaders fileSize(Long fileSize) {
        this.headers.put("CamelAzureStorageDataLakeFileSize", fileSize);
        return this;
    }

    public DataLakeExchangeHeaders lastModified(OffsetDateTime lastModified) {
        this.headers.put("CamelAzureStorageDataLakeLastModified", lastModified);
        if (lastModified != null) {
            long ts = lastModified.toEpochSecond() * 1000L;
            this.headers.put("CamelMessageTimestamp", ts);
        }
        return this;
    }

    public DataLakeExchangeHeaders leaseDuration(LeaseDurationType leaseDuration) {
        this.headers.put("CamelAzureStorageDataLakeLeaseDuration", leaseDuration);
        return this;
    }

    public DataLakeExchangeHeaders leaseState(LeaseStateType leaseState) {
        this.headers.put("CamelAzureStorageDataLakeLeaseState", leaseState);
        return this;
    }

    public DataLakeExchangeHeaders leaseStatus(LeaseStatusType leaseStatus) {
        this.headers.put("CamelAzureStorageDataLakeLeaseStatus", leaseStatus);
        return this;
    }

    public DataLakeExchangeHeaders metadata(Map<String, String> metadata) {
        this.headers.put("CamelAzureStorageDataLakeMetadata", metadata);
        return this;
    }

    public DataLakeExchangeHeaders incrementalCopy(Boolean incrementalCopy) {
        this.headers.put("CamelAzureStorageDataLakeIncrementalCopy", incrementalCopy);
        return this;
    }

    public DataLakeExchangeHeaders serverEncrypted(Boolean serverEncrypted) {
        this.headers.put("CamelAzureStorageDataLakeServerEncrypted", serverEncrypted);
        return this;
    }

    public DataLakeExchangeHeaders fileName(String fileName) {
        this.headers.put("CamelAzureStorageDataLakeFileName", fileName);
        return this;
    }

    public DataLakeExchangeHeaders downloadLink(String downloadLink) {
        this.headers.put("CamelAzureStorageDataLakeDownloadLink", downloadLink);
        return this;
    }

    public DataLakeExchangeHeaders fileClient(DataLakeFileClient fileClient) {
        this.headers.put("CamelAzureStorageDataLakeFileClient", fileClient);
        return this;
    }
}

