/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.groups;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.groups.Groups;

public class GroupsComputer {
    public static final Class<?>[] DEFAULT_GROUP = new Class[]{Default.class};
    private static final Groups DEFAULT_GROUPS = new GroupsComputer().computeGroups(Arrays.asList(DEFAULT_GROUP));
    private final Map<Class<?>, List<Group>> resolvedSequences = new ConcurrentHashMap();

    public Groups computeGroups(Class<?>[] groups) {
        if (groups == null) {
            throw new IllegalArgumentException("null passed as group");
        }
        if (groups.length == 0) {
            return DEFAULT_GROUPS;
        }
        return this.computeGroups(Arrays.asList(groups));
    }

    protected Groups computeGroups(Collection<Class<?>> groups) {
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException("At least one group has to be specified.");
        }
        for (Class<?> clazz : groups) {
            if (clazz == null) {
                throw new IllegalArgumentException("At least one group has to be specified.");
            }
            if (clazz.isInterface()) continue;
            throw new ValidationException("A group has to be an interface. " + clazz.getName() + " is not.");
        }
        Groups chain = new Groups();
        for (Class<?> clazz : groups) {
            GroupSequence anno = clazz.getAnnotation(GroupSequence.class);
            if (anno == null) {
                Group group = new Group(clazz);
                chain.insertGroup(group);
                this.insertInheritedGroups(clazz, chain);
                continue;
            }
            this.insertSequence(clazz, anno, chain);
        }
        return chain;
    }

    private void insertInheritedGroups(Class<?> clazz, Groups chain) {
        for (Class<?> extendedInterface : clazz.getInterfaces()) {
            Group group = new Group(extendedInterface);
            chain.insertGroup(group);
            this.insertInheritedGroups(extendedInterface, chain);
        }
    }

    private void insertSequence(Class<?> clazz, GroupSequence anno, Groups chain) {
        List<Group> sequence = this.resolvedSequences.containsKey(clazz) ? this.resolvedSequences.get(clazz) : this.resolveSequence(clazz, anno, new HashSet());
        chain.insertSequence(sequence);
    }

    private List<Group> resolveSequence(Class<?> group, GroupSequence sequenceAnnotation, Set<Class<?>> processedSequences) {
        Class[] sequenceArray;
        if (processedSequences.contains(group)) {
            throw new GroupDefinitionException("Cyclic dependency in groups definition");
        }
        processedSequences.add(group);
        LinkedList<Group> resolvedGroupSequence = new LinkedList<Group>();
        for (Class clazz : sequenceArray = sequenceAnnotation.value()) {
            GroupSequence anno = clazz.getAnnotation(GroupSequence.class);
            if (anno == null) {
                resolvedGroupSequence.add(new Group(clazz));
                continue;
            }
            List<Group> tmpSequence = this.resolveSequence(clazz, anno, processedSequences);
            resolvedGroupSequence.addAll(tmpSequence);
        }
        this.resolvedSequences.put(group, resolvedGroupSequence);
        return resolvedGroupSequence;
    }
}

