/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.KdcHandler;
import org.apache.kerby.kerberos.kerb.transport.KrbTcpTransport;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKdcHandler
extends KdcHandler
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(DefaultKdcHandler.class);
    private final KrbTransport transport;

    public DefaultKdcHandler(KdcContext kdcContext, KrbTransport transport) {
        super(kdcContext);
        this.transport = transport;
    }

    @Override
    public void run() {
        try {
            while (true) {
                ByteBuffer message;
                if ((message = this.transport.receiveMessage()) == null) {
                    logger.debug("No valid request recved. Disconnect actively");
                    this.transport.release();
                    break;
                }
                this.handleMessage(message);
            }
        }
        catch (IOException e) {
            this.transport.release();
            logger.debug("Transport or decoding error occurred, disconnecting abnormally", e);
        }
    }

    protected void handleMessage(ByteBuffer message) {
        InetAddress clientAddress = this.transport.getRemoteAddress();
        boolean isTcp = this.transport instanceof KrbTcpTransport;
        try {
            ByteBuffer krbResponse = this.handleMessage(message, isTcp, clientAddress);
            this.transport.sendMessage(krbResponse);
        }
        catch (Exception e) {
            this.transport.release();
            logger.error("Error occured while processing request:", e);
        }
    }
}

