/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.launcher.ServiceLauncher;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HadoopUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUncaughtExceptionHandler.class);
    private final Thread.UncaughtExceptionHandler delegate;

    public HadoopUncaughtExceptionHandler(Thread.UncaughtExceptionHandler delegate) {
        this.delegate = delegate;
    }

    public HadoopUncaughtExceptionHandler() {
        this(null);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        if (ShutdownHookManager.get().isShutdownInProgress()) {
            LOG.error("Thread {} threw an error during shutdown: {}.", thread.toString(), exception, exception);
        } else if (exception instanceof Error) {
            try {
                LOG.error("Thread {} threw an error: {}. Shutting down", thread.toString(), exception, exception);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (exception instanceof OutOfMemoryError) {
                try {
                    System.err.println("Halting due to Out Of Memory Error...");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ExitUtil.haltOnOutOfMemory((OutOfMemoryError)exception);
            } else {
                ExitUtil.ExitException ee = ServiceLauncher.convertToExitException(exception);
                ExitUtil.terminate(ee.status, ee);
            }
        } else {
            LOG.error("Thread {} threw an exception: {}", thread.toString(), exception, exception);
            if (this.delegate != null) {
                this.delegate.uncaughtException(thread, exception);
            }
        }
    }
}

