/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.aries.blueprint.NamespaceHandler;
import org.apache.aries.blueprint.ext.impl.ExtNamespaceHandler;
import org.apache.aries.blueprint.parser.NamespaceHandlerSet;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNamespaceHandlerSet
implements NamespaceHandlerSet {
    public static final URI EXT_1_2_NAMESPACE = URI.create("http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.2.0");
    private Set<URI> namespaces = new LinkedHashSet<URI>();
    private Schema schema;

    public SimpleNamespaceHandlerSet() {
        this.namespaces.add(EXT_1_2_NAMESPACE);
    }

    @Override
    public Set<URI> getNamespaces() {
        return Collections.unmodifiableSet(this.namespaces);
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public NamespaceHandler getNamespaceHandler(URI uri) {
        if (EXT_1_2_NAMESPACE.equals(uri)) {
            return new ExtNamespaceHandler();
        }
        return null;
    }

    @Override
    public Schema getSchema() throws SAXException, IOException {
        if (this.schema == null) {
            ArrayList<StreamSource> schemaSources = new ArrayList<StreamSource>();
            schemaSources.add(new StreamSource(this.getClass().getResourceAsStream("/org/apache/aries/blueprint/blueprint.xsd")));
            schemaSources.add(new StreamSource(this.getClass().getResourceAsStream("/org/apache/aries/blueprint/ext/impl/blueprint-ext-1.2.xsd")));
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schema = schemaFactory.newSchema(schemaSources.toArray(new Source[schemaSources.size()]));
        }
        return this.schema;
    }

    @Override
    public void addListener(NamespaceHandlerSet.Listener listener) {
        throw new IllegalStateException();
    }

    @Override
    public void removeListener(NamespaceHandlerSet.Listener listener) {
        throw new IllegalStateException();
    }

    @Override
    public void destroy() {
        this.schema = null;
    }
}

