/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.container;

import java.net.URI;
import java.net.URL;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.ExtendedBeanMetadata;
import org.apache.aries.blueprint.Processor;
import org.apache.aries.blueprint.container.AggregateConverter;
import org.apache.aries.blueprint.container.BlueprintRepository;
import org.apache.aries.blueprint.container.IdSpace;
import org.apache.aries.blueprint.container.NoOsgiRecipeBuilder;
import org.apache.aries.blueprint.container.SimpleNamespaceHandlerSet;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.parser.ComponentDefinitionRegistryImpl;
import org.apache.aries.blueprint.parser.Parser;
import org.apache.aries.blueprint.reflect.MetadataUtil;
import org.apache.aries.blueprint.reflect.PassThroughMetadataImpl;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.container.Converter;
import org.osgi.service.blueprint.container.NoSuchComponentException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueprintContainerImpl
implements ExtendedBlueprintContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintContainerImpl.class);
    private final ClassLoader loader;
    private final List<URL> resources;
    private final AggregateConverter converter;
    private final ComponentDefinitionRegistryImpl componentDefinitionRegistry;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final IdSpace tempRecipeIdSpace = new IdSpace();
    private BlueprintRepository repository;
    private List<Processor> processors = new ArrayList<Processor>();
    private Map<String, String> properties;

    public BlueprintContainerImpl(ClassLoader loader, List<URL> resources) throws Exception {
        this(loader, resources, null, true);
    }

    public BlueprintContainerImpl(ClassLoader loader, List<URL> resources, boolean init) throws Exception {
        this(loader, resources, null, init);
    }

    public BlueprintContainerImpl(ClassLoader loader, List<URL> resources, Map<String, String> properties, boolean init) throws Exception {
        this.loader = loader;
        this.converter = new AggregateConverter(this);
        this.componentDefinitionRegistry = new ComponentDefinitionRegistryImpl();
        this.resources = resources;
        this.properties = properties;
        if (init) {
            this.init();
        }
    }

    @Override
    public String getProperty(String key) {
        if (this.properties != null && this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return System.getProperty(key);
    }

    public void init() throws Exception {
        Parser parser = new Parser();
        parser.parse(this.getResources());
        SimpleNamespaceHandlerSet handlerSet = new SimpleNamespaceHandlerSet();
        Set<URI> namespaces = parser.getNamespaces();
        LinkedHashSet<URI> unsupported = new LinkedHashSet<URI>();
        for (URI ns : namespaces) {
            if (handlerSet.getNamespaces().contains(ns)) continue;
            unsupported.add(ns);
        }
        if (unsupported.size() > 0) {
            throw new IllegalArgumentException("Unsupported namespaces: " + ((Object)unsupported).toString());
        }
        this.componentDefinitionRegistry.registerComponentDefinition(new PassThroughMetadataImpl("blueprintContainer", this));
        parser.validate(handlerSet.getSchema());
        parser.populate(handlerSet, this.componentDefinitionRegistry);
        this.repository = new NoOsgiRecipeBuilder(this, this.tempRecipeIdSpace).createRepository();
        this.processTypeConverters();
        this.processProcessors();
        this.instantiateEagerComponents();
    }

    public void destroy() {
        this.repository.destroy();
    }

    public List<URL> getResources() {
        return this.resources;
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    @Override
    public AccessControlContext getAccessControlContext() {
        return null;
    }

    @Override
    public ComponentDefinitionRegistryImpl getComponentDefinitionRegistry() {
        return this.componentDefinitionRegistry;
    }

    @Override
    public <T extends Processor> List<T> getProcessors(Class<T> clazz) {
        ArrayList<T> p = new ArrayList<T>();
        for (Processor processor : this.processors) {
            if (!clazz.isInstance(processor)) continue;
            p.add(clazz.cast(processor));
        }
        return p;
    }

    @Override
    public Set<String> getComponentIds() {
        return new LinkedHashSet<String>(this.componentDefinitionRegistry.getComponentDefinitionNames());
    }

    @Override
    public Object getComponentInstance(String id) {
        if (this.repository == null || this.destroyed.get()) {
            throw new NoSuchComponentException(id);
        }
        try {
            LOGGER.debug("Instantiating component {}", (Object)id);
            return this.repository.create(id);
        }
        catch (NoSuchComponentException e) {
            throw e;
        }
        catch (ComponentDefinitionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ComponentDefinitionException("Cound not create component instance for " + id, t);
        }
    }

    @Override
    public ComponentMetadata getComponentMetadata(String id) {
        ComponentMetadata metadata = this.componentDefinitionRegistry.getComponentDefinition(id);
        if (metadata == null) {
            throw new NoSuchComponentException(id);
        }
        return metadata;
    }

    @Override
    public <T extends ComponentMetadata> Collection<T> getMetadata(Class<T> clazz) {
        Collection metadatas = new ArrayList();
        for (String name : this.componentDefinitionRegistry.getComponentDefinitionNames()) {
            ComponentMetadata component = this.componentDefinitionRegistry.getComponentDefinition(name);
            this.getMetadata(clazz, component, metadatas);
        }
        metadatas = Collections.unmodifiableCollection(metadatas);
        return metadatas;
    }

    public BlueprintRepository getRepository() {
        return this.repository;
    }

    private <T extends ComponentMetadata> void getMetadata(Class<T> clazz, Metadata component, Collection<T> metadatas) {
        if (component == null) {
            return;
        }
        if (clazz.isInstance(component)) {
            metadatas.add(clazz.cast(component));
        }
        if (component instanceof BeanMetadata) {
            this.getMetadata(clazz, ((BeanMetadata)component).getFactoryComponent(), metadatas);
            for (BeanArgument beanArgument : ((BeanMetadata)component).getArguments()) {
                this.getMetadata(clazz, beanArgument.getValue(), metadatas);
            }
            for (BeanProperty beanProperty : ((BeanMetadata)component).getProperties()) {
                this.getMetadata(clazz, beanProperty.getValue(), metadatas);
            }
        }
        if (component instanceof CollectionMetadata) {
            for (Metadata metadata : ((CollectionMetadata)component).getValues()) {
                this.getMetadata(clazz, metadata, metadatas);
            }
        }
        if (component instanceof MapMetadata) {
            for (MapEntry mapEntry : ((MapMetadata)component).getEntries()) {
                this.getMetadata(clazz, mapEntry.getKey(), metadatas);
                this.getMetadata(clazz, mapEntry.getValue(), metadatas);
            }
        }
        if (component instanceof PropsMetadata) {
            for (MapEntry mapEntry : ((PropsMetadata)component).getEntries()) {
                this.getMetadata(clazz, mapEntry.getKey(), metadatas);
                this.getMetadata(clazz, mapEntry.getValue(), metadatas);
            }
        }
        if (component instanceof ServiceReferenceMetadata) {
            for (ReferenceListener referenceListener : ((ServiceReferenceMetadata)component).getReferenceListeners()) {
                this.getMetadata(clazz, referenceListener.getListenerComponent(), metadatas);
            }
        }
        if (component instanceof ServiceMetadata) {
            this.getMetadata(clazz, ((ServiceMetadata)component).getServiceComponent(), metadatas);
            for (MapEntry mapEntry : ((ServiceMetadata)component).getServiceProperties()) {
                this.getMetadata(clazz, mapEntry.getKey(), metadatas);
                this.getMetadata(clazz, mapEntry.getValue(), metadatas);
            }
            for (RegistrationListener registrationListener : ((ServiceMetadata)component).getRegistrationListeners()) {
                this.getMetadata(clazz, registrationListener.getListenerComponent(), metadatas);
            }
        }
    }

    private void processTypeConverters() throws Exception {
        ArrayList<String> typeConverters = new ArrayList<String>();
        for (Target target : this.componentDefinitionRegistry.getTypeConverters()) {
            if (target instanceof ComponentMetadata) {
                typeConverters.add(((ComponentMetadata)((Object)target)).getId());
                continue;
            }
            if (target instanceof RefMetadata) {
                typeConverters.add(((RefMetadata)target).getComponentId());
                continue;
            }
            throw new ComponentDefinitionException("Unexpected metadata for type converter: " + target);
        }
        Map<String, Object> objects = this.repository.createAll(typeConverters, Arrays.asList(Converter.class));
        for (String name : typeConverters) {
            Object obj = objects.get(name);
            if (obj instanceof Converter) {
                this.converter.registerConverter((Converter)obj);
                continue;
            }
            throw new ComponentDefinitionException("Type converter " + obj + " does not implement the " + Converter.class.getName() + " interface");
        }
    }

    private void processProcessors() throws Exception {
        for (BeanMetadata bean : this.getMetadata(BeanMetadata.class)) {
            Object obj;
            if (bean instanceof ExtendedBeanMetadata && !((ExtendedBeanMetadata)bean).isProcessor()) continue;
            Class clazz = null;
            if (bean instanceof ExtendedBeanMetadata) {
                clazz = ((ExtendedBeanMetadata)bean).getRuntimeClass();
            }
            if (clazz == null && bean.getClassName() != null) {
                clazz = this.loadClass(bean.getClassName());
            }
            if (clazz == null) continue;
            if (ComponentDefinitionRegistryProcessor.class.isAssignableFrom(clazz)) {
                obj = this.repository.create(bean.getId(), Arrays.asList(ComponentDefinitionRegistryProcessor.class));
                ((ComponentDefinitionRegistryProcessor)obj).process(this.componentDefinitionRegistry);
            } else {
                if (!Processor.class.isAssignableFrom(clazz)) continue;
                obj = this.repository.create(bean.getId(), Arrays.asList(Processor.class));
                this.processors.add((Processor)obj);
            }
            this.updateUninstantiatedRecipes();
        }
    }

    private void updateUninstantiatedRecipes() {
        BlueprintRepository tmpRepo = new NoOsgiRecipeBuilder(this, this.tempRecipeIdSpace).createRepository();
        LOGGER.debug("Updating blueprint repository");
        for (String name : this.repository.getNames()) {
            if (this.repository.getInstance(name) == null) {
                LOGGER.debug("Removing uninstantiated recipe {}", new Object[]{name});
                this.repository.removeRecipe(name);
                continue;
            }
            LOGGER.debug("Recipe {} is already instantiated", new Object[]{name});
        }
        for (String name : tmpRepo.getNames()) {
            if (this.repository.getInstance(name) == null) {
                LOGGER.debug("Adding new recipe {}", new Object[]{name});
                Recipe r = tmpRepo.getRecipe(name);
                if (r == null) continue;
                this.repository.putRecipe(name, r);
                continue;
            }
            LOGGER.debug("Recipe {} is already instantiated and cannot be updated", new Object[]{name});
        }
    }

    protected void instantiateEagerComponents() {
        ArrayList<String> components = new ArrayList<String>();
        for (String name : this.componentDefinitionRegistry.getComponentDefinitionNames()) {
            boolean eager;
            ComponentMetadata component = this.componentDefinitionRegistry.getComponentDefinition(name);
            boolean bl = eager = component.getActivation() == 1;
            if (component instanceof BeanMetadata) {
                BeanMetadata local = (BeanMetadata)component;
                eager &= MetadataUtil.isSingletonScope(local);
            }
            if (!eager) continue;
            components.add(name);
        }
        LOGGER.debug("Instantiating components: {}", components);
        try {
            this.repository.createAll(components);
        }
        catch (ComponentDefinitionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ComponentDefinitionException("Unable to instantiate components", t);
        }
    }
}

