/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.net.URISyntaxException;
import java.util.Map;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.uri.URISupport;

public class ParameterisedAddress {
    private final SimpleString address;
    private final QueueAttributes queueAttributes;

    public static SimpleString toParameterisedAddress(SimpleString address, Map<String, String> parameters) throws URISyntaxException {
        if (parameters != null && !parameters.isEmpty()) {
            return SimpleString.toSimpleString(ParameterisedAddress.toParameterisedAddress(address.toString(), parameters));
        }
        return address;
    }

    public static String toParameterisedAddress(String address, Map<String, String> parameters) throws URISyntaxException {
        if (parameters != null && !parameters.isEmpty()) {
            return URISupport.appendParameters(new StringBuilder(address), parameters).toString();
        }
        return address;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public QueueAttributes getQueueAttributes() {
        return this.queueAttributes;
    }

    public ParameterisedAddress(SimpleString address, QueueAttributes queueAttributes) {
        this.address = address;
        this.queueAttributes = queueAttributes;
    }

    public ParameterisedAddress(String address, QueueAttributes queueAttributes) {
        this(SimpleString.toSimpleString(address), queueAttributes);
    }

    public ParameterisedAddress(SimpleString address) {
        this(address.toString());
    }

    public ParameterisedAddress(String address) {
        int index = address.indexOf(63);
        if (index == -1) {
            this.address = SimpleString.toSimpleString(address);
            this.queueAttributes = null;
        } else {
            this.address = SimpleString.toSimpleString(address.substring(0, index));
            QueueAttributes queueAttributes = new QueueAttributes();
            try {
                URISupport.parseQuery(address).forEach(queueAttributes::set);
            }
            catch (URISyntaxException use) {
                throw new IllegalArgumentException("Malformed parameters in address " + address);
            }
            this.queueAttributes = queueAttributes;
        }
    }

    public boolean isParameterised() {
        return this.queueAttributes != null;
    }

    public static boolean isParameterised(String address) {
        return URISupport.containsQuery(address);
    }

    public static boolean isParameterised(SimpleString address) {
        return URISupport.containsQuery(address);
    }
}

