/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.console.command.AbstractCommand;
import sun.management.ConnectorAddressLink;

public abstract class AbstractJmxCommand
extends AbstractCommand {
    public static final String DEFAULT_JMX_URL = "service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi";
    private JMXServiceURL jmxServiceUrl;
    private String jmxUser;
    private String jmxPassword;
    private boolean jmxUseLocal;
    private JMXConnector jmxConnector;
    private MBeanServerConnection jmxConnection;

    protected JMXServiceURL getJmxServiceUrl() {
        return this.jmxServiceUrl;
    }

    public static String getJVM() {
        return System.getProperty("java.vm.specification.vendor");
    }

    public static boolean isSunJVM() {
        return AbstractJmxCommand.getJVM().equals("Sun Microsystems Inc.");
    }

    protected JMXServiceURL useJmxServiceUrl() throws MalformedURLException {
        if (this.getJmxServiceUrl() == null) {
            String jmxUrl = DEFAULT_JMX_URL;
            int connectingPid = -1;
            if (AbstractJmxCommand.isSunJVM()) {
                try {
                    String javaHome = System.getProperty("java.home");
                    String tools = javaHome + File.separator + ".." + File.separator + "lib" + File.separator + "tools.jar";
                    URLClassLoader loader = new URLClassLoader(new URL[]{new File(tools).toURI().toURL()});
                    Class<?> monitoredHostClass = Class.forName("sun.jvmstat.monitor.MonitoredHost", true, loader);
                    Method getMonitoredHostMethod = monitoredHostClass.getMethod("getMonitoredHost", String.class);
                    Object host = getMonitoredHostMethod.invoke(null, new Object[]{null});
                    Method activeVmsMethod = host.getClass().getMethod("activeVms", null);
                    Set vms = (Set)activeVmsMethod.invoke(host, null);
                    for (Object vmid : vms) {
                        int pid = (Integer)vmid;
                        Class<?> vmIdentifierClass = Class.forName("sun.jvmstat.monitor.VmIdentifier", true, loader);
                        Constructor<?> vmIdentifierConstructor = vmIdentifierClass.getConstructor(String.class);
                        Object vmIdentifier = vmIdentifierConstructor.newInstance(vmid.toString());
                        Method getMonitoredVmMethod = host.getClass().getMethod("getMonitoredVm", vmIdentifierClass);
                        Object mvm = getMonitoredVmMethod.invoke(host, vmIdentifier);
                        Class<?> monitoredVmUtilClass = Class.forName("sun.jvmstat.monitor.MonitoredVmUtil", true, loader);
                        Method commandLineMethod = monitoredVmUtilClass.getMethod("commandLine", Class.forName("sun.jvmstat.monitor.MonitoredVm", true, loader));
                        String name = (String)commandLineMethod.invoke(null, mvm);
                        if (!name.contains("run.jar start")) continue;
                        connectingPid = pid;
                        jmxUrl = ConnectorAddressLink.importFrom((int)pid);
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (connectingPid != -1) {
                this.context.print("Connecting to pid: " + connectingPid);
            } else {
                this.context.print("Connecting to JMX URL: " + jmxUrl);
            }
            this.setJmxServiceUrl(jmxUrl);
        }
        return this.getJmxServiceUrl();
    }

    protected void setJmxServiceUrl(JMXServiceURL jmxServiceUrl) {
        this.jmxServiceUrl = jmxServiceUrl;
    }

    protected void setJmxServiceUrl(String jmxServiceUrl) throws MalformedURLException {
        this.setJmxServiceUrl(new JMXServiceURL(jmxServiceUrl));
    }

    public String getJmxUser() {
        return this.jmxUser;
    }

    public void setJmxUser(String jmxUser) {
        this.jmxUser = jmxUser;
    }

    public String getJmxPassword() {
        return this.jmxPassword;
    }

    public void setJmxPassword(String jmxPassword) {
        this.jmxPassword = jmxPassword;
    }

    public boolean isJmxUseLocal() {
        return this.jmxUseLocal;
    }

    public void setJmxUseLocal(boolean jmxUseLocal) {
        this.jmxUseLocal = jmxUseLocal;
    }

    private JMXConnector createJmxConnector() throws IOException {
        if (this.jmxConnector != null) {
            this.jmxConnector.connect();
            return this.jmxConnector;
        }
        if (this.jmxUser != null && this.jmxPassword != null) {
            HashMap<String, String[]> props = new HashMap<String, String[]>();
            props.put("jmx.remote.credentials", new String[]{this.jmxUser, this.jmxPassword});
            this.jmxConnector = JMXConnectorFactory.connect(this.useJmxServiceUrl(), props);
        } else {
            this.jmxConnector = JMXConnectorFactory.connect(this.useJmxServiceUrl());
        }
        return this.jmxConnector;
    }

    protected void closeJmxConnection() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
                this.jmxConnector = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected MBeanServerConnection createJmxConnection() throws IOException {
        if (this.jmxConnection == null) {
            this.jmxConnection = this.isJmxUseLocal() ? ManagementFactory.getPlatformMBeanServer() : this.createJmxConnector().getMBeanServerConnection();
        }
        return this.jmxConnection;
    }

    @Override
    protected void handleOption(String token, List<String> tokens) throws Exception {
        if (token.equals("--jmxurl")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("JMX URL not specified."));
            }
            if (this.getJmxServiceUrl() != null) {
                this.context.printException(new IllegalArgumentException("Multiple JMX URL cannot be specified."));
                tokens.clear();
            }
            String strJmxUrl = tokens.remove(0);
            try {
                this.setJmxServiceUrl(new JMXServiceURL(strJmxUrl));
            }
            catch (MalformedURLException e) {
                this.context.printException(e);
                tokens.clear();
            }
        } else if (token.equals("--pid")) {
            if (AbstractJmxCommand.isSunJVM()) {
                if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                    this.context.printException(new IllegalArgumentException("pid not specified"));
                    return;
                }
                int pid = Integer.parseInt(tokens.remove(0));
                this.context.print("Connecting to pid: " + pid);
                String jmxUrl = ConnectorAddressLink.importFrom((int)pid);
                if (this.getJmxServiceUrl() != null) {
                    this.context.printException(new IllegalArgumentException("JMX URL already specified."));
                    tokens.clear();
                }
                try {
                    this.setJmxServiceUrl(new JMXServiceURL(jmxUrl));
                }
                catch (MalformedURLException e) {
                    this.context.printException(e);
                    tokens.clear();
                }
            } else {
                this.context.printInfo("--pid option is not available for this VM, using default JMX url");
            }
        } else if (token.equals("--jmxuser")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("JMX user not specified."));
            }
            this.setJmxUser(tokens.remove(0));
        } else if (token.equals("--jmxpassword")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("JMX password not specified."));
            }
            this.setJmxPassword(tokens.remove(0));
        } else if (token.equals("--jmxlocal")) {
            this.setJmxUseLocal(true);
        } else {
            super.handleOption(token, tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(List<String> tokens) throws Exception {
        try {
            super.execute(tokens);
        }
        finally {
            this.closeJmxConnection();
        }
    }
}

