/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.virtual.VirtualTopicInterceptor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;

public class SelectorAwareVirtualTopicInterceptor
extends VirtualTopicInterceptor {
    public SelectorAwareVirtualTopicInterceptor(Destination next, String prefix, String postfix) {
        super(next, prefix, postfix);
    }

    @Override
    protected void send(ProducerBrokerExchange context, Message message, ActiveMQDestination destination) throws Exception {
        Broker broker = context.getConnectionContext().getBroker();
        Set<Destination> destinations = broker.getDestinations(destination);
        for (Destination dest : destinations) {
            if (!this.matchesSomeConsumer(message, dest)) continue;
            dest.send(context, message.copy());
        }
    }

    private boolean matchesSomeConsumer(Message message, Destination dest) throws IOException {
        boolean matches = false;
        NonCachedMessageEvaluationContext msgContext = new NonCachedMessageEvaluationContext();
        msgContext.setDestination(dest.getActiveMQDestination());
        ((MessageEvaluationContext)msgContext).setMessageReference(message);
        List<Subscription> subs = dest.getConsumers();
        for (Subscription sub : subs) {
            if (!sub.matches(message, msgContext)) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

