/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.exception.status.InvalidArgumentException;
import alluxio.grpc.JobInfo;
import alluxio.grpc.JobType;
import alluxio.job.util.SerializableVoid;
import alluxio.job.util.SerializationUtils;
import alluxio.job.wire.JobInfo;
import alluxio.job.wire.Status;
import alluxio.util.CommonUtils;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class TaskInfo
implements JobInfo {
    private static final Logger LOG = LoggerFactory.getLogger(TaskInfo.class);
    private long mJobId;
    private long mTaskId;
    private Status mStatus;
    private String mErrorType;
    private String mErrorMessage;
    private Serializable mResult;
    private long mLastUpdated;
    private String mWorkerHost;
    private String mDescription;

    public TaskInfo() {
        this.mErrorType = "";
        this.mErrorMessage = "";
        this.mDescription = "";
    }

    public TaskInfo(long jobId, long taskId, Status status, WorkerNetAddress workerAddress, Object args) {
        this.mJobId = jobId;
        this.mTaskId = taskId;
        this.mStatus = status;
        this.mErrorType = "";
        this.mErrorMessage = "";
        this.mResult = null;
        this.mWorkerHost = workerAddress.getHost();
        this.mDescription = TaskInfo.createDescription(args);
    }

    private static String createDescription(Object args) {
        if (args instanceof Collection) {
            return Arrays.toString(((Collection)args).toArray());
        }
        if (args instanceof SerializableVoid) {
            return "";
        }
        return ObjectUtils.toString((Object)args);
    }

    public TaskInfo(alluxio.grpc.JobInfo taskInfo) throws IOException {
        Preconditions.checkArgument((boolean)taskInfo.getType().equals((Object)JobType.TASK), (Object)"Invalid type");
        this.mJobId = taskInfo.getParentId();
        this.mTaskId = taskInfo.getId();
        this.mStatus = Status.valueOf(taskInfo.getStatus().name());
        this.mErrorType = taskInfo.getErrorType();
        this.mErrorMessage = taskInfo.getErrorMessage();
        this.mWorkerHost = taskInfo.getWorkerHost();
        this.mResult = null;
        if (taskInfo.hasResult()) {
            try {
                this.mResult = SerializationUtils.deserialize(taskInfo.getResult().toByteArray());
            }
            catch (ClassNotFoundException e) {
                throw new InvalidArgumentException((Throwable)e);
            }
        }
        this.mLastUpdated = taskInfo.getLastUpdated();
        this.mDescription = taskInfo.getDescription();
    }

    @Override
    public long getId() {
        return this.getTaskId();
    }

    public long getTaskId() {
        return this.mTaskId;
    }

    public TaskInfo setTaskId(long taskId) {
        this.mTaskId = taskId;
        return this;
    }

    @Override
    public Long getParentId() {
        return this.getJobId();
    }

    public long getJobId() {
        return this.mJobId;
    }

    public Object getWorkerHost() {
        return this.mWorkerHost;
    }

    public TaskInfo setJobId(long jobId) {
        this.mJobId = jobId;
        return this;
    }

    @Override
    public String getName() {
        return String.format("Task %s", this.mTaskId);
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    @Override
    public Status getStatus() {
        return this.mStatus;
    }

    public TaskInfo setStatus(Status status) {
        this.mStatus = status;
        this.updateLastUpdated();
        return this;
    }

    @Override
    public long getLastUpdated() {
        return this.mLastUpdated;
    }

    private void updateLastUpdated() {
        this.mLastUpdated = CommonUtils.getCurrentMs();
    }

    @Override
    public List<JobInfo> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public String getErrorType() {
        return this.mErrorType;
    }

    public TaskInfo setErrorType(String errorType) {
        this.mErrorType = errorType;
        return this;
    }

    @Override
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public TaskInfo setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
        return this;
    }

    @Override
    public Serializable getResult() {
        return this.mResult;
    }

    public TaskInfo setResult(Serializable result) {
        this.mResult = result;
        return this;
    }

    public TaskInfo setWorkerHost(String workerHost) {
        this.mWorkerHost = workerHost;
        return this;
    }

    @Override
    public alluxio.grpc.JobInfo toProto() {
        ByteBuffer result = null;
        try {
            result = this.mResult == null ? null : ByteBuffer.wrap(SerializationUtils.serialize(this.mResult));
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {}", (Object)this.mResult, (Object)e);
        }
        JobInfo.Builder taskInfoBuilder = alluxio.grpc.JobInfo.newBuilder().setParentId(this.mJobId).setId(this.mTaskId).setStatus(this.mStatus.toProto()).setErrorMessage(this.mErrorMessage).setErrorType(this.mErrorType).setLastUpdated(this.mLastUpdated).setWorkerHost(this.mWorkerHost).setType(JobType.TASK).setDescription(this.mDescription);
        if (result != null) {
            taskInfoBuilder.setResult(ByteString.copyFrom((ByteBuffer)result));
        }
        return taskInfoBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskInfo)) {
            return false;
        }
        TaskInfo that = (TaskInfo)o;
        return Objects.equal((Object)this.mJobId, (Object)that.mJobId) && Objects.equal((Object)this.mTaskId, (Object)that.mTaskId) && Objects.equal((Object)((Object)this.mStatus), (Object)((Object)that.mStatus)) && Objects.equal((Object)this.mErrorMessage, (Object)that.mErrorMessage) && Objects.equal((Object)this.mResult, (Object)that.mResult) && Objects.equal((Object)this.mLastUpdated, (Object)that.mLastUpdated) && Objects.equal((Object)this.mWorkerHost, (Object)that.mWorkerHost) && Objects.equal((Object)this.mErrorType, (Object)that.mErrorType) && Objects.equal((Object)this.mDescription, (Object)that.mDescription);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mJobId, this.mTaskId, this.mStatus, this.mErrorMessage, this.mResult, this.mLastUpdated, this.mWorkerHost, this.mDescription});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jobId", this.mJobId).add("taskId", this.mTaskId).add("status", (Object)this.mStatus).add("errorMessage", (Object)this.mErrorMessage).add("result", (Object)this.mResult).add("lastUpdated", this.mLastUpdated).add("workerHost", (Object)this.mWorkerHost).add("description", (Object)this.mDescription).toString();
    }
}

