/*
 * Decompiled with CFR 0.152.
 */
package alluxio.job.wire;

import alluxio.grpc.JobStatusBlock;
import alluxio.job.wire.SimpleJobStatusBlock;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CmdStatusBlock {
    private long mJobControlId;
    private List<SimpleJobStatusBlock> mJobStatusBlockList;

    public CmdStatusBlock(long jobControlId) {
        this.mJobControlId = jobControlId;
        this.mJobStatusBlockList = Lists.newArrayList();
    }

    public CmdStatusBlock(long jobControlId, List<SimpleJobStatusBlock> blocks) {
        this.mJobControlId = jobControlId;
        this.mJobStatusBlockList = blocks;
    }

    public long getJobControlId() {
        return this.mJobControlId;
    }

    public void addJobStatusBlock(SimpleJobStatusBlock block) {
        this.mJobStatusBlockList.add(block);
    }

    public List<SimpleJobStatusBlock> getJobStatusBlock() {
        return this.mJobStatusBlockList;
    }

    public alluxio.grpc.CmdStatusBlock toProto() throws IOException {
        ArrayList jobStatusBlockList = Lists.newArrayList();
        this.mJobStatusBlockList.forEach(block -> {
            JobStatusBlock protoBlock = JobStatusBlock.newBuilder().setJobId(block.getJobId()).setJobStatus(block.getStatus().toProto()).build();
            jobStatusBlockList.add(protoBlock);
        });
        return alluxio.grpc.CmdStatusBlock.newBuilder().setJobControlId(this.mJobControlId).addAllJobStatusBlock((Iterable)jobStatusBlockList).build();
    }
}

