/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.DataObjectImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.runtime.DataObject;
import org.activiti.engine.task.Task;

public class GetTaskDataObjectsCmd
implements Command<Map<String, DataObject>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Collection<String> variableNames;
    protected String locale;
    protected boolean withLocalizationFallback;

    public GetTaskDataObjectsCmd(String taskId, Collection<String> variableNames) {
        this.taskId = taskId;
        this.variableNames = variableNames;
    }

    public GetTaskDataObjectsCmd(String taskId, Collection<String> variableNames, String locale, boolean withLocalizationFallback) {
        this.taskId = taskId;
        this.variableNames = variableNames;
        this.locale = locale;
        this.withLocalizationFallback = withLocalizationFallback;
    }

    @Override
    public Map<String, DataObject> execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiIllegalArgumentException("taskId is null");
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            throw new ActivitiObjectNotFoundException("task " + this.taskId + " doesn't exist", Task.class);
        }
        HashMap<String, DataObjectImpl> dataObjects = null;
        Map<String, VariableInstance> variables = null;
        variables = this.variableNames == null ? task.getVariableInstances() : task.getVariableInstances(this.variableNames, false);
        if (variables != null) {
            dataObjects = new HashMap<String, DataObjectImpl>(variables.size());
            for (Map.Entry<String, VariableInstance> entry : variables.entrySet()) {
                ObjectNode languageNode;
                VariableInstance variableEntity = entry.getValue();
                String localizedName = null;
                String localizedDescription = null;
                ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(variableEntity.getExecutionId());
                while (!executionEntity.isScope()) {
                    executionEntity = executionEntity.getParent();
                }
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(executionEntity.getProcessDefinitionId());
                ValuedDataObject foundDataObject = null;
                if (executionEntity.getParentId() == null) {
                    for (ValuedDataObject dataObject : bpmnModel.getMainProcess().getDataObjects()) {
                        if (!dataObject.getName().equals(variableEntity.getName())) continue;
                        foundDataObject = dataObject;
                        break;
                    }
                } else {
                    ValuedDataObject dataObject;
                    SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(executionEntity.getActivityId());
                    dataObject = subProcess.getDataObjects().iterator();
                    while (dataObject.hasNext()) {
                        ValuedDataObject dataObject2 = (ValuedDataObject)dataObject.next();
                        if (!dataObject2.getName().equals(variableEntity.getName())) continue;
                        foundDataObject = dataObject2;
                        break;
                    }
                }
                if (this.locale != null && foundDataObject != null && (languageNode = Context.getLocalizationElementProperties(this.locale, foundDataObject.getId(), task.getProcessDefinitionId(), this.withLocalizationFallback)) != null) {
                    JsonNode descriptionNode;
                    JsonNode nameNode = languageNode.get("name");
                    if (nameNode != null) {
                        localizedName = nameNode.asText();
                    }
                    if ((descriptionNode = languageNode.get("description")) != null) {
                        localizedDescription = descriptionNode.asText();
                    }
                }
                if (foundDataObject == null) continue;
                dataObjects.put(variableEntity.getName(), new DataObjectImpl(variableEntity.getName(), variableEntity.getValue(), foundDataObject.getDocumentation(), foundDataObject.getType(), localizedName, localizedDescription, foundDataObject.getId()));
            }
        }
        return dataObjects;
    }
}

