/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.deployer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.UserTask;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.DynamicBpmnService;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.deployer.BpmnDeploymentHelper;
import org.activiti.engine.impl.bpmn.deployer.CachingAndArtifactsManager;
import org.activiti.engine.impl.bpmn.deployer.ParsedDeployment;
import org.activiti.engine.impl.bpmn.deployer.ParsedDeploymentBuilderFactory;
import org.activiti.engine.impl.bpmn.deployer.ResourceNameUtil;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.Deployer;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(BpmnDeployer.class);
    protected IdGenerator idGenerator;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected BpmnDeploymentHelper bpmnDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;

    @Override
    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        log.debug("Processing deployment {}", (Object)deployment.getName());
        ParsedDeployment parsedDeployment = this.parsedDeploymentBuilderFactory.getBuilderForDeploymentAndSettings(deployment, deploymentSettings).build();
        this.bpmnDeploymentHelper.verifyProcessDefinitionsDoNotShareKeys(parsedDeployment.getAllProcessDefinitions());
        this.bpmnDeploymentHelper.copyDeploymentValuesToProcessDefinitions(parsedDeployment.getDeployment(), parsedDeployment.getAllProcessDefinitions());
        this.bpmnDeploymentHelper.setResourceNamesOnProcessDefinitions(parsedDeployment);
        this.setProcessDefinitionDiagramNames(parsedDeployment);
        if (deployment.isNew()) {
            Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapOfNewProcessDefinitionToPreviousVersion = this.getPreviousVersionsOfProcessDefinitions(parsedDeployment);
            this.setProcessDefinitionVersionsAndIds(parsedDeployment, mapOfNewProcessDefinitionToPreviousVersion);
            this.persistProcessDefinitionsAndAuthorizations(parsedDeployment);
            this.updateTimersAndEvents(parsedDeployment, mapOfNewProcessDefinitionToPreviousVersion);
            this.dispatchProcessDefinitionEntityInitializedEvent(parsedDeployment);
        } else {
            this.makeProcessDefinitionsConsistentWithPersistedVersions(parsedDeployment);
        }
        this.cachingAndArtifactsManager.updateCachingAndArtifacts(parsedDeployment);
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            BpmnModel bpmnModel = parsedDeployment.getBpmnModelForProcessDefinition(processDefinition);
            this.createLocalizationValues(processDefinition.getId(), bpmnModel.getProcessById(processDefinition.getKey()));
        }
    }

    protected void setProcessDefinitionDiagramNames(ParsedDeployment parsedDeployment) {
        Map<String, ResourceEntity> resources = parsedDeployment.getDeployment().getResources();
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            String diagramResourceName = ResourceNameUtil.getProcessDiagramResourceNameFromDeployment(processDefinition, resources);
            processDefinition.setDiagramResourceName(diagramResourceName);
        }
    }

    protected Map<ProcessDefinitionEntity, ProcessDefinitionEntity> getPreviousVersionsOfProcessDefinitions(ParsedDeployment parsedDeployment) {
        LinkedHashMap<ProcessDefinitionEntity, ProcessDefinitionEntity> result = new LinkedHashMap<ProcessDefinitionEntity, ProcessDefinitionEntity>();
        for (ProcessDefinitionEntity newDefinition : parsedDeployment.getAllProcessDefinitions()) {
            ProcessDefinitionEntity existingDefinition = this.bpmnDeploymentHelper.getMostRecentVersionOfProcessDefinition(newDefinition);
            if (existingDefinition == null) continue;
            result.put(newDefinition, existingDefinition);
        }
        return result;
    }

    protected void setProcessDefinitionVersionsAndIds(ParsedDeployment parsedDeployment, Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapNewToOldProcessDefinitions) {
        CommandContext commandContext = Context.getCommandContext();
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            int version = 1;
            ProcessDefinitionEntity latest = mapNewToOldProcessDefinitions.get(processDefinition);
            if (latest != null) {
                version = latest.getVersion() + 1;
            }
            processDefinition.setVersion(version);
            processDefinition.setId(this.getIdForNewProcessDefinition(processDefinition));
            if (!commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, processDefinition));
        }
    }

    protected void persistProcessDefinitionsAndAuthorizations(ParsedDeployment parsedDeployment) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntityManager processDefinitionManager = commandContext.getProcessDefinitionEntityManager();
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            processDefinitionManager.insert(processDefinition, false);
            this.bpmnDeploymentHelper.addAuthorizationsForNewProcessDefinition(parsedDeployment.getProcessModelForProcessDefinition(processDefinition), processDefinition);
        }
    }

    protected void updateTimersAndEvents(ParsedDeployment parsedDeployment, Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapNewToOldProcessDefinitions) {
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            this.bpmnDeploymentHelper.updateTimersAndEvents(processDefinition, mapNewToOldProcessDefinitions.get(processDefinition), parsedDeployment);
        }
    }

    protected void dispatchProcessDefinitionEntityInitializedEvent(ParsedDeployment parsedDeployment) {
        CommandContext commandContext = Context.getCommandContext();
        for (ProcessDefinitionEntity processDefinitionEntity : parsedDeployment.getAllProcessDefinitions()) {
            log.info("Process deployed: {id: " + processDefinitionEntity.getId() + ", key: " + processDefinitionEntity.getKey() + ", name: " + processDefinitionEntity.getName() + " }");
            if (!commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, processDefinitionEntity));
        }
    }

    protected String getIdForNewProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String nextId = this.idGenerator.getNextId();
        String result = processDefinition.getKey() + ":" + processDefinition.getVersion() + ":" + nextId;
        if (result.length() > 64) {
            result = nextId;
        }
        return result;
    }

    protected void makeProcessDefinitionsConsistentWithPersistedVersions(ParsedDeployment parsedDeployment) {
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            ProcessDefinitionEntity persistedProcessDefinition = this.bpmnDeploymentHelper.getPersistedInstanceOfProcessDefinition(processDefinition);
            if (persistedProcessDefinition == null) continue;
            processDefinition.setId(persistedProcessDefinition.getId());
            processDefinition.setVersion(persistedProcessDefinition.getVersion());
            processDefinition.setSuspensionState(persistedProcessDefinition.getSuspensionState());
        }
    }

    protected void createLocalizationValues(String processDefinitionId, Process process) {
        if (process == null) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        DynamicBpmnService dynamicBpmnService = commandContext.getProcessEngineConfiguration().getDynamicBpmnService();
        ObjectNode infoNode = dynamicBpmnService.getProcessDefinitionInfo(processDefinitionId);
        boolean localizationValuesChanged = false;
        List localizationElements = (List)process.getExtensionElements().get("localization");
        if (localizationElements != null) {
            for (ExtensionElement localizationElement : localizationElements) {
                String processId;
                Iterator iterator;
                if (!"activiti".equals(localizationElement.getNamespacePrefix())) continue;
                String locale = localizationElement.getAttributeValue(null, "locale");
                String name = localizationElement.getAttributeValue(null, "name");
                String documentation = null;
                List documentationElements = (List)localizationElement.getChildElements().get("documentation");
                if (documentationElements != null && (iterator = documentationElements.iterator()).hasNext()) {
                    ExtensionElement documentationElement = (ExtensionElement)iterator.next();
                    documentation = StringUtils.trimToNull((String)documentationElement.getElementText());
                }
                if (!this.isEqualToCurrentLocalizationValue(locale, processId = process.getId(), "name", name, infoNode)) {
                    dynamicBpmnService.changeLocalizationName(locale, processId, name, infoNode);
                    localizationValuesChanged = true;
                }
                if (documentation == null || this.isEqualToCurrentLocalizationValue(locale, processId, "description", documentation, infoNode)) break;
                dynamicBpmnService.changeLocalizationDescription(locale, processId, documentation, infoNode);
                localizationValuesChanged = true;
                break;
            }
        }
        boolean isFlowElementLocalizationChanged = this.localizeFlowElements(process.getFlowElements(), infoNode);
        boolean isDataObjectLocalizationChanged = this.localizeDataObjectElements(process.getDataObjects(), infoNode);
        if (isFlowElementLocalizationChanged || isDataObjectLocalizationChanged) {
            localizationValuesChanged = true;
        }
        if (localizationValuesChanged) {
            dynamicBpmnService.saveProcessDefinitionInfo(processDefinitionId, infoNode);
        }
    }

    protected boolean localizeFlowElements(Collection<FlowElement> flowElements, ObjectNode infoNode) {
        boolean localizationValuesChanged = false;
        if (flowElements == null) {
            return localizationValuesChanged;
        }
        CommandContext commandContext = Context.getCommandContext();
        DynamicBpmnService dynamicBpmnService = commandContext.getProcessEngineConfiguration().getDynamicBpmnService();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask) && !(flowElement instanceof SubProcess)) continue;
            List localizationElements = (List)flowElement.getExtensionElements().get("localization");
            if (localizationElements != null) {
                for (ExtensionElement localizationElement : localizationElements) {
                    String flowElementId;
                    Iterator iterator;
                    if (!"activiti".equals(localizationElement.getNamespacePrefix())) continue;
                    String locale = localizationElement.getAttributeValue(null, "locale");
                    String name = localizationElement.getAttributeValue(null, "name");
                    String documentation = null;
                    List documentationElements = (List)localizationElement.getChildElements().get("documentation");
                    if (documentationElements != null && (iterator = documentationElements.iterator()).hasNext()) {
                        ExtensionElement documentationElement = (ExtensionElement)iterator.next();
                        documentation = StringUtils.trimToNull((String)documentationElement.getElementText());
                    }
                    if (!this.isEqualToCurrentLocalizationValue(locale, flowElementId = flowElement.getId(), "name", name, infoNode)) {
                        dynamicBpmnService.changeLocalizationName(locale, flowElementId, name, infoNode);
                        localizationValuesChanged = true;
                    }
                    if (documentation == null || this.isEqualToCurrentLocalizationValue(locale, flowElementId, "description", documentation, infoNode)) break;
                    dynamicBpmnService.changeLocalizationDescription(locale, flowElementId, documentation, infoNode);
                    localizationValuesChanged = true;
                    break;
                }
            }
            if (!(flowElement instanceof SubProcess)) continue;
            SubProcess subprocess = (SubProcess)flowElement;
            boolean isFlowElementLocalizationChanged = this.localizeFlowElements(subprocess.getFlowElements(), infoNode);
            boolean isDataObjectLocalizationChanged = this.localizeDataObjectElements(subprocess.getDataObjects(), infoNode);
            if (!isFlowElementLocalizationChanged && !isDataObjectLocalizationChanged) continue;
            localizationValuesChanged = true;
        }
        return localizationValuesChanged;
    }

    protected boolean isEqualToCurrentLocalizationValue(String language, String id, String propertyName, String propertyValue, ObjectNode infoNode) {
        boolean isEqual = false;
        JsonNode localizationNode = infoNode.path("localization").path(language).path(id).path(propertyName);
        if (!localizationNode.isMissingNode() && !localizationNode.isNull() && localizationNode.asText().equals(propertyValue)) {
            isEqual = true;
        }
        return isEqual;
    }

    protected boolean localizeDataObjectElements(List<ValuedDataObject> dataObjects, ObjectNode infoNode) {
        boolean localizationValuesChanged = false;
        CommandContext commandContext = Context.getCommandContext();
        DynamicBpmnService dynamicBpmnService = commandContext.getProcessEngineConfiguration().getDynamicBpmnService();
        for (ValuedDataObject dataObject : dataObjects) {
            List localizationElements = (List)dataObject.getExtensionElements().get("localization");
            if (localizationElements == null) continue;
            for (ExtensionElement localizationElement : localizationElements) {
                Iterator iterator;
                if (!"activiti".equals(localizationElement.getNamespacePrefix())) continue;
                String locale = localizationElement.getAttributeValue(null, "locale");
                String name = localizationElement.getAttributeValue(null, "name");
                String documentation = null;
                List documentationElements = (List)localizationElement.getChildElements().get("documentation");
                if (documentationElements != null && (iterator = documentationElements.iterator()).hasNext()) {
                    ExtensionElement documentationElement = (ExtensionElement)iterator.next();
                    documentation = StringUtils.trimToNull((String)documentationElement.getElementText());
                }
                if (name != null && !this.isEqualToCurrentLocalizationValue(locale, dataObject.getId(), "name", name, infoNode)) {
                    dynamicBpmnService.changeLocalizationName(locale, dataObject.getId(), name, infoNode);
                    localizationValuesChanged = true;
                }
                if (documentation == null || this.isEqualToCurrentLocalizationValue(locale, dataObject.getId(), "description", documentation, infoNode)) continue;
                dynamicBpmnService.changeLocalizationDescription(locale, dataObject.getId(), documentation, infoNode);
                localizationValuesChanged = true;
            }
        }
        return localizationValuesChanged;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public ParsedDeploymentBuilderFactory getExParsedDeploymentBuilderFactory() {
        return this.parsedDeploymentBuilderFactory;
    }

    public void setParsedDeploymentBuilderFactory(ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory) {
        this.parsedDeploymentBuilderFactory = parsedDeploymentBuilderFactory;
    }

    public BpmnDeploymentHelper getBpmnDeploymentHelper() {
        return this.bpmnDeploymentHelper;
    }

    public void setBpmnDeploymentHelper(BpmnDeploymentHelper bpmnDeploymentHelper) {
        this.bpmnDeploymentHelper = bpmnDeploymentHelper;
    }

    public CachingAndArtifactsManager getCachingAndArtifcatsManager() {
        return this.cachingAndArtifactsManager;
    }

    public void setCachingAndArtifactsManager(CachingAndArtifactsManager manager) {
        this.cachingAndArtifactsManager = manager;
    }
}

