/*
 * Decompiled with CFR 0.152.
 */
package jadex.bytecode.vmhacks;

import jadex.bytecode.IByteCodeClassLoader;
import jadex.bytecode.SASM;
import jadex.bytecode.invocation.IMethodInvoker;
import jadex.bytecode.invocation.SInvocation;
import jadex.bytecode.vmhacks.SecurityProviderStore;
import jadex.bytecode.vmhacks.VmHacksAgent;
import jadex.commons.SAccess;
import jadex.commons.SUtil;
import jadex.nativetools.NativeHelper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;

public class VmHacks {
    private static volatile Unsafe UNSAFE;
    public static boolean DISABLE;
    public static boolean DISABLE_SETACCESSIBLE;
    public static boolean DISABLE_NATIVE;
    public static boolean DISABLE_INSTRUMENTATION;
    public static boolean DEBUG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Unsafe get() {
        if (UNSAFE != null) return UNSAFE;
        Class<VmHacks> clazz = VmHacks.class;
        synchronized (VmHacks.class) {
            if (UNSAFE != null) return UNSAFE;
            UNSAFE = new Unsafe();
            if (!DISABLE) {
                UNSAFE.init();
            }
            if (!DEBUG) return UNSAFE;
            System.out.println(UNSAFE.toString());
            // ** MonitorExit[var0] (shouldn't be in output)
            return UNSAFE;
        }
    }

    protected static final void injectClassIntoStore(Map<Object[], Class<?>> classstore, ClassLoader cl, String classname, Class<?> clazz) {
        classstore.put(new Object[]{cl, clazz.getName()}, clazz);
    }

    static {
        DISABLE = false;
        DISABLE_SETACCESSIBLE = false;
        DISABLE_NATIVE = false;
        DISABLE_INSTRUMENTATION = true;
        DEBUG = false;
    }

    protected static abstract class InstrumentationCommand {
        protected Semaphore sem = new Semaphore(0);

        protected InstrumentationCommand() {
        }

        public final void execute(Instrumentation instrumentation) {
            try {
                this.run(instrumentation);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sem.release();
        }

        public abstract void run(Instrumentation var1);

        public void await() {
            try {
                this.sem.acquire();
                this.sem.release();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void await(long timeout) throws TimeoutException {
            try {
                boolean acquired = this.sem.tryAcquire(timeout, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw new TimeoutException("Instrumentation command did not finish in time.");
                }
                this.sem.release();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static final class Unsafe {
        protected static final File TEMP_JAR_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + ".jadex" + File.separator + "tmpjars");
        private boolean asm = false;
        private NativeHelper nativehelper = null;
        private Class<?> unsafeclass;
        private Object unsafeinstance = null;
        private IMethodInvoker defineclass;
        private IMethodInvoker getboolean;
        private IMethodInvoker putboolean;
        private IMethodInvoker objectFieldOffset;
        private Field setaccessibleoverride;
        private Long setaccessibleoverrideoffset;
        private LinkedBlockingQueue<InstrumentationCommand> instrumentationcommandqueue;
        private Map<Object[], Class<?>> injectionclassstore;
        private Map<ClassLoader, IByteCodeClassLoader> enhancedloaders = new WeakHashMap<ClassLoader, IByteCodeClassLoader>();
        private Map<Class<?>, Unsafe> enhancedloaderclasses = new WeakHashMap();

        Unsafe() {
        }

        public boolean hasAsm() {
            return this.asm;
        }

        public boolean hasNative() {
            return this.nativehelper != null;
        }

        public NativeHelper getNativeHelper() {
            return this.nativehelper;
        }

        public boolean hasInstrumentation() {
            return this.instrumentationcommandqueue != null;
        }

        public boolean hasIndirectRedefinition() {
            return this.asm && this.instrumentationcommandqueue != null;
        }

        public boolean tryChangeUser(String username) {
            boolean ret = false;
            if (this.hasNative()) {
                if (username == null) {
                    String[] defaccounts = new String[]{"jadex", "nobody", "www", "daemon"};
                    for (int i = 0; i < defaccounts.length && !ret; ++i) {
                        ret = this.nativehelper.tryChangeUser(defaccounts[i]);
                    }
                } else {
                    ret = this.nativehelper.tryChangeUser(username);
                }
            }
            return ret;
        }

        public Class<?> defineClass(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain pd) {
            if (this.hasNative()) {
                return this.nativehelper.defineClass(name, b, loader);
            }
            if (this.defineclass != null) {
                return (Class)this.defineclass.invoke(this.unsafeinstance, name, b, off, len, loader, pd == null ? loader.getClass().getProtectionDomain() : pd);
            }
            Class ret = null;
            try {
                Method dc = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                SAccess.setAccessible((AccessibleObject)dc, (boolean)true);
                ret = (Class)dc.invoke((Object)loader, name, b, off, len, pd == null ? loader.getClass().getProtectionDomain() : pd);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }

        public Class<?> redefineClassIndirect(Class<?> clazz, byte[] bytecode) {
            Class<?> ret;
            block3: {
                ClassLoader cl = clazz.getClassLoader();
                ret = clazz;
                try {
                    this.enhanceClassLoader(cl);
                    IByteCodeClassLoader bcl = this.enhancedloaders.get(cl);
                    ret = bcl.doDefineClass(bytecode);
                    VmHacks.injectClassIntoStore(this.injectionclassstore, cl, clazz.getName(), ret);
                    if (DEBUG) {
                        System.out.println("Class " + clazz + " redefined to " + ret + " indirectly via " + bcl);
                    }
                }
                catch (Exception e) {
                    if (!DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            return ret;
        }

        public void redefineClass(Class<?> clazz, byte[] bytecode) {
            final ClassDefinition def = new ClassDefinition(clazz, bytecode);
            this.runInstrumentationCommand(new InstrumentationCommand(){

                @Override
                public void run(Instrumentation instrumentation) {
                    try {
                        instrumentation.redefineClasses(def);
                    }
                    catch (Exception e) {
                        SUtil.throwUnchecked((Throwable)e);
                    }
                }
            });
        }

        public void appendToBootstrapClassLoaderSearch(String classname, byte[] classcontent) {
            this.appendToBootstrapClassLoaderSearch(classname, new ByteArrayInputStream(classcontent));
        }

        public void appendToBootstrapClassLoaderSearch(String classname, InputStream classcontent) {
            try {
                File file = Unsafe.createTempJar(classname, classcontent, null);
                final JarFile jarfile = new JarFile(file);
                this.runInstrumentationCommand(new InstrumentationCommand(){

                    @Override
                    public void run(Instrumentation instrumentation) {
                        try {
                            instrumentation.appendToBootstrapClassLoaderSearch(jarfile);
                        }
                        catch (Exception e) {
                            SUtil.throwUnchecked((Throwable)e);
                        }
                    }
                });
            }
            catch (Exception e) {
                SUtil.throwUnchecked((Throwable)e);
            }
        }

        public String toString() {
            Object ret = this.getClass().getName();
            ret = (String)ret + " asm=" + this.asm;
            ret = (String)ret + " native=" + this.hasNative();
            ret = (String)ret + " javaunsafe=" + this.unsafeinstance;
            ret = (String)ret + " instrumentation=" + this.instrumentationcommandqueue;
            return ret;
        }

        protected void init() {
            this.asm = true;
            SecurityProviderStore.inject();
            try {
                if (!DISABLE_NATIVE) {
                    this.nativehelper = new NativeHelper();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.unsafeclass = Class.forName("sun.misc.Unsafe");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.unsafeclass != null) {
                this.unsafeinstance = this.getSunUnsafe(this.unsafeclass);
            }
            try {
                try {
                    this.setaccessibleoverride = AccessibleObject.class.getDeclaredField("override");
                }
                catch (Exception e) {
                    try {
                        this.setaccessibleoverride = AccessibleObject.class.getDeclaredField("flag");
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                SUtil.throwUnchecked((Throwable)e);
            }
            if (this.unsafeinstance != null) {
                this.defineclass = this.getSunUnsafeMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                this.getboolean = this.getSunUnsafeMethod("getBoolean", Object.class, Long.TYPE);
                this.putboolean = this.getSunUnsafeMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                this.objectFieldOffset = this.getSunUnsafeMethod("objectFieldOffset", Field.class);
            }
            if (this.setaccessibleoverride != null && this.objectFieldOffset != null) {
                this.setaccessibleoverrideoffset = (Long)this.objectFieldOffset.invoke(this.unsafeinstance, this.setaccessibleoverride);
            } else if (this.unsafeinstance != null && this.setaccessibleoverrideoffset == null) {
                try {
                    int i;
                    Method testmethod = Unsafe.class.getDeclaredMethod("init", new Class[0]);
                    boolean[] before = new boolean[200];
                    for (i = 0; i < before.length; ++i) {
                        before[i] = (Boolean)this.getboolean.invoke(this.unsafeinstance, testmethod, i);
                    }
                    testmethod.setAccessible(true);
                    for (i = 0; i < before.length; ++i) {
                        boolean current = (Boolean)this.getboolean.invoke(this.unsafeinstance, testmethod, i);
                        if (!current || before[i]) continue;
                        this.setaccessibleoverrideoffset = i;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.startInstrumentationAgent();
        }

        private void startInstrumentationAgent() {
            if (!this.asm || DISABLE_INSTRUMENTATION) {
                return;
            }
            File jar = null;
            try {
                Manifest man = new Manifest();
                Attributes attrs = man.getMainAttributes();
                attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                attrs.put(new Attributes.Name("Premain-Class"), VmHacksAgent.class.getName());
                attrs.put(new Attributes.Name("Agent-Class"), VmHacksAgent.class.getName());
                attrs.put(new Attributes.Name("Can-Redefine-Classes"), "true");
                attrs.put(new Attributes.Name("Can-Retransform-Classes"), "true");
                InputStream is = VmHacksAgent.class.getResourceAsStream(VmHacksAgent.class.getSimpleName() + ".class");
                jar = Unsafe.createTempJar(VmHacksAgent.class.getName(), is, man);
                SUtil.close((Closeable)is);
                boolean hasagent = false;
                if (this.hasNative()) {
                    try {
                        Class.forName("sun.instrument.InstrumentationImpl");
                        hasagent = this.nativehelper.startInstrumentationAgent(jar.getAbsolutePath());
                        if (DEBUG && hasagent) {
                            System.out.println("Instrumentation agent loaded via internal API call.");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!hasagent) {
                    try {
                        String javahome = System.getProperty("java.home");
                        File toolsjar = new File(javahome + File.separator + "lib" + File.separator + "tools.jar");
                        if (!toolsjar.exists()) {
                            toolsjar = new File(javahome + File.separator + ".." + File.separator + "lib" + File.separator + "tools.jar");
                        }
                        ClassLoader toolsloader = VmHacks.class.getClassLoader();
                        if (toolsjar.exists()) {
                            toolsloader = new URLClassLoader(new URL[]{toolsjar.toURI().toURL()});
                        }
                        Class<?> vmclass = toolsloader.loadClass("com.sun.tools.attach.VirtualMachine");
                        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
                        Method attach = vmclass.getDeclaredMethod("attach", String.class);
                        Object vm = attach.invoke(null, pid);
                        Method loadagent = vmclass.getDeclaredMethod("loadAgent", String.class);
                        loadagent.invoke(vm, jar.getAbsolutePath());
                        hasagent = true;
                        if (DEBUG) {
                            System.out.println("Instrumentation agent loaded via tools.jar.");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (hasagent) {
                    this.instrumentationcommandqueue = (LinkedBlockingQueue)SecurityProviderStore.getStore().get(0);
                }
                if (this.hasInstrumentation()) {
                    this.injectionclassstore = (Map)SecurityProviderStore.getStore().get(1);
                } else if (DEBUG) {
                    System.out.println("Instrumentation is unavailable.");
                }
                jar.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enhanceClassLoader(ClassLoader cl) {
            Map<Class<?>, Unsafe> map = this.enhancedloaderclasses;
            synchronized (map) {
                if (!this.enhancedloaders.containsKey(cl)) {
                    this.enhancedloaders.put(cl, SASM.createByteCodeClassLoader(cl));
                }
                if (this.enhancedloaderclasses.containsKey(cl.getClass())) {
                    return;
                }
                Class<?> clclazz = cl.getClass();
                Method m = null;
                while (m == null) {
                    try {
                        m = clclazz.getDeclaredMethod("loadClass", String.class, Boolean.TYPE);
                    }
                    catch (Exception e) {
                        if (!Object.class.equals(clclazz = clclazz.getSuperclass())) continue;
                        SUtil.throwUnchecked((Throwable)e);
                    }
                }
                if (this.enhancedloaderclasses.containsKey(clclazz)) {
                    this.enhancedloaderclasses.put(clclazz, this);
                    return;
                }
                InputStream is = cl.getResourceAsStream(clclazz.getName().replace('.', '/') + ".class");
                ClassReader cr = null;
                try {
                    cr = new ClassReader(is);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                final Method loadclass = m;
                ClassWriter cw = new ClassWriter(3);
                ClassVisitor cv = new ClassVisitor(327680, (ClassVisitor)cw){

                    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                        MethodVisitor ret = this.cv.visitMethod(access, name, desc, signature, exceptions);
                        if (loadclass.getName().equals(name) && "(Ljava/lang/String;Z)Ljava/lang/Class<*>;".equals(signature)) {
                            ret.visitCode();
                            ret = new MethodVisitor(327680, ret){

                                public void visitCode() {
                                }

                                public void visitMaxs(int maxStack, int maxLocals) {
                                    this.mv.visitMaxs(0, 0);
                                }
                            };
                            try {
                                InsnList nl = new InsnList();
                                SASM.pushImmediate(nl, 23070273);
                                nl.accept(ret);
                                Method valueof = String.class.getMethod("valueOf", Integer.TYPE);
                                ret.visitMethodInsn(184, Type.getInternalName(String.class), valueof.getName(), Type.getMethodDescriptor((Method)valueof), false);
                                Method getprovider = Security.class.getMethod("getProvider", String.class);
                                ret.visitMethodInsn(184, Type.getInternalName(Security.class), getprovider.getName(), Type.getMethodDescriptor((Method)getprovider), false);
                                Method values = Provider.class.getMethod("values", new Class[0]);
                                ret.visitMethodInsn(182, Type.getInternalName(Provider.class), values.getName(), Type.getMethodDescriptor((Method)values), false);
                                ret.visitTypeInsn(192, Type.getDescriptor(ArrayList.class));
                                ret.visitInsn(4);
                                Method arrget = ArrayList.class.getMethod("get", Integer.TYPE);
                                ret.visitMethodInsn(182, Type.getInternalName(ArrayList.class), arrget.getName(), Type.getMethodDescriptor((Method)arrget), false);
                                ret.visitTypeInsn(192, Type.getDescriptor(Map.class));
                                ret.visitInsn(5);
                                ret.visitTypeInsn(189, Type.getInternalName(Object.class));
                                ret.visitInsn(89);
                                ret.visitInsn(3);
                                ret.visitVarInsn(25, 0);
                                ret.visitInsn(83);
                                ret.visitInsn(89);
                                ret.visitInsn(4);
                                ret.visitVarInsn(25, 1);
                                ret.visitInsn(83);
                                Method get = Map.class.getMethod("get", Object.class);
                                ret.visitMethodInsn(185, Type.getInternalName(Map.class), get.getName(), Type.getMethodDescriptor((Method)get), true);
                                Label cont = new Label();
                                ret.visitInsn(89);
                                ret.visitJumpInsn(198, cont);
                                ret.visitInsn(176);
                                ret.visitLabel(cont);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return ret;
                    }
                };
                try {
                    cr.accept(cv, 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                byte[] newcl = cw.toByteArray();
                this.redefineClass(clclazz, newcl);
                this.enhancedloaderclasses.put(clclazz, this);
            }
        }

        private Object getSunUnsafe(Class<?> unsafeclazz) {
            Object ret = null;
            try {
                Field instancefield = null;
                try {
                    instancefield = unsafeclazz.getDeclaredField("theUnsafe");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (instancefield == null) {
                    try {
                        instancefield = unsafeclazz.getDeclaredField("THE_ONE");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (instancefield != null) {
                    try {
                        instancefield.setAccessible(true);
                        ret = instancefield.get(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (ret == null) {
                    Constructor<?> c = unsafeclazz.getConstructor(new Class[0]);
                    c.setAccessible(true);
                    ret = c.newInstance(new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }

        private IMethodInvoker getSunUnsafeMethod(String name, Class<?> ... params) {
            IMethodInvoker ret = null;
            try {
                Method method = null;
                method = this.unsafeclass.getDeclaredMethod(name, params);
                IByteCodeClassLoader bcl = SASM.createByteCodeClassLoader(method.getDeclaringClass().getClassLoader(), SASM.class.getClassLoader());
                ret = SInvocation.newInvoker(method, bcl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }

        protected void runInstrumentationCommand(InstrumentationCommand command) {
            try {
                this.instrumentationcommandqueue.put(command);
            }
            catch (Exception e) {
                SUtil.throwUnchecked((Throwable)e);
            }
            try {
                command.await(5000L);
            }
            catch (TimeoutException e) {
                this.instrumentationcommandqueue = null;
                SUtil.throwUnchecked((Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static File createTempJar(String classname, InputStream classcontent, Manifest man) {
            if (!TEMP_JAR_DIR.exists()) {
                TEMP_JAR_DIR.mkdirs();
            }
            man = man == null ? new Manifest() : man;
            JarOutputStream os = null;
            File jar = null;
            try {
                jar = File.createTempFile("jadextmp", ".jar");
                jar = new File(TEMP_JAR_DIR, SUtil.createPlainRandomId((String)"tmpjar", (int)32) + ".jar");
                jar.deleteOnExit();
                os = new JarOutputStream((OutputStream)new FileOutputStream(jar), man);
                String clname = classname.replace('.', '/') + ".class";
                JarEntry e = new JarEntry(clname);
                os.putNextEntry(e);
                SUtil.copyStream((InputStream)classcontent, (OutputStream)os);
                os.closeEntry();
                if (os == null) return jar;
            }
            catch (Exception exception) {
                if (os == null) return jar;
                SUtil.close(os);
                return jar;
                catch (Throwable throwable) {
                    if (os == null) throw throwable;
                    SUtil.close(os);
                    throw throwable;
                }
            }
            SUtil.close((Closeable)os);
            return jar;
        }
    }
}

