/*
 * Decompiled with CFR 0.152.
 */
package jadex.bytecode.invocation;

import jadex.bytecode.IByteCodeClassLoader;
import jadex.bytecode.SASM;
import jadex.bytecode.invocation.IExtractor;
import jadex.bytecode.invocation.IInjector;
import jadex.bytecode.invocation.IMethodInvoker;
import jadex.bytecode.vmhacks.VmHacks;
import jadex.commons.SAccess;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.collection.WeakKeyValueMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SInvocation {
    public static AtomicLong NAME_SUFFIX_COUNTER = new AtomicLong();
    public static boolean DEFAULT_ACCESS = false;
    public static boolean PRIVATE_ACCESS = false;
    protected static volatile WeakHashMap<Method, Class<IMethodInvoker>> INVOKER_CLASSES = new WeakHashMap();
    protected static volatile WeakHashMap<Class<?>, WeakKeyValueMap<Class<?>, Class<?>>> ACCESSOR_CLASSES = new WeakHashMap();
    protected static volatile WeakHashMap<Class<?>, WeakKeyValueMap<Class<?>, Class<?>>> EXTRACTOR_CLASSES = new WeakHashMap();

    public static final Object invoke(Object obj, String methodname, Object ... args) {
        return SInvocation.invoke(obj, null, methodname, args);
    }

    public static final Object invoke(Object obj, Class<?> clazz, String methodname, Object ... args) {
        Method[] methods = SReflect.getAllMethods(clazz = clazz == null ? obj.getClass() : clazz, (String)methodname);
        if (methods.length == 1) {
            return SInvocation.newInvoker(methods[0]).invoke(obj, args);
        }
        int argcount = args != null ? args.length : 0;
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getParameterTypes().length != argcount) continue;
            return SInvocation.newInvoker(methods[i]).invoke(obj, args);
        }
        throw new IllegalArgumentException("No unambiguous method + " + methodname + " found, try " + SInvocation.class.getName() + "getInvoker() methods.");
    }

    public static final IMethodInvoker newInvoker(Method method) {
        Class<IMethodInvoker> ic = SInvocation.getInvokerClass(method);
        if (ic == null) {
            return new FallBackInvoker(method);
        }
        return SInvocation.newInvoker(ic);
    }

    public static final IMethodInvoker newInvoker(Method method, IByteCodeClassLoader cl) {
        Class<IMethodInvoker> ic = SInvocation.createInvokerClass(cl, method);
        if (ic == null) {
            return new FallBackInvoker(method);
        }
        return SInvocation.newInvoker(ic);
    }

    protected static final IMethodInvoker newInvoker(Class<?> invokerclass) {
        try {
            Constructor<?> c = invokerclass.getConstructor(null);
            return (IMethodInvoker)c.newInstance(null);
        }
        catch (Exception e) {
            throw SUtil.throwUnchecked((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Class<IMethodInvoker> getInvokerClass(Method method) {
        Class<IMethodInvoker> ic = INVOKER_CLASSES.get(method);
        if (ic == null) {
            if (INVOKER_CLASSES.containsKey(method)) {
                return null;
            }
            AtomicLong atomicLong = NAME_SUFFIX_COUNTER;
            synchronized (atomicLong) {
                ic = INVOKER_CLASSES.get(method);
                if (ic == null) {
                    ClassLoader cl = method.getDeclaringClass().getClassLoader();
                    IByteCodeClassLoader bcl = SASM.getByteCodeClassLoader(cl);
                    ic = SInvocation.createInvokerClass(bcl, method);
                    WeakHashMap<Method, Class<IMethodInvoker>> newgenclasses = new WeakHashMap<Method, Class<IMethodInvoker>>(INVOKER_CLASSES);
                    newgenclasses.put(method, ic);
                    INVOKER_CLASSES = newgenclasses;
                }
            }
        }
        return ic;
    }

    protected static final Class<IMethodInvoker> createInvokerClass(IByteCodeClassLoader cl, Method method) {
        Class<?> ret = null;
        try {
            int accesslevel;
            Class<?> clazz = method.getDeclaringClass();
            if (!clazz.equals(cl.loadClass(clazz.getName()))) {
                throw new IllegalArgumentException("Code generation classloader " + cl + " does not have access to class " + clazz + " defined in method " + method.getName());
            }
            boolean isstatic = (method.getModifiers() & 8) != 0;
            String classname = "MethodInvoker_" + method.getName() + "_" + NAME_SUFFIX_COUNTER.incrementAndGet();
            ExtendedClassWriter cw = SInvocation.createClass(clazz, classname, accesslevel = SInvocation.determineAccessLevel(1, method.getModifiers()), IMethodInvoker.class);
            if (cw == null) {
                return null;
            }
            Method invmethod = IMethodInvoker.class.getMethod("invoke", Object.class, Object[].class);
            MethodVisitor mv = cw.visitMethod(1, invmethod.getName(), Type.getMethodDescriptor((Method)invmethod), null, null);
            mv.visitCode();
            if (!isstatic) {
                mv.visitVarInsn(25, 1);
                mv.visitTypeInsn(192, Type.getInternalName(clazz));
            }
            SInvocation.prepareParameters(mv, method.getParameterTypes());
            if (isstatic) {
                mv.visitMethodInsn(184, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), false);
            } else {
                mv.visitMethodInsn(182, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), false);
            }
            if (SReflect.isBasicType(method.getReturnType()) && !Void.TYPE.equals(method.getReturnType())) {
                Class wt = SReflect.getWrappedType(method.getReturnType());
                Method wm = wt.getMethod("valueOf", method.getReturnType());
                mv.visitMethodInsn(184, Type.getInternalName((Class)wt), wm.getName(), Type.getMethodDescriptor((Method)wm), false);
            }
            if (Void.TYPE.equals(method.getReturnType())) {
                mv.visitInsn(1);
            }
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            byte[] classcode = cw.toByteArray();
            ret = cw.requiresParentLoader() ? cl.doDefineClassInParent(null, classcode, 0, classcode.length, clazz.getProtectionDomain()) : cl.doDefineClass(classcode);
        }
        catch (Exception e) {
            SUtil.throwUnchecked((Throwable)e);
        }
        return ret;
    }

    public static final <T> T newAccessor(Class<T> iface, Class<?> targetclass, Object delegate) {
        Class<T> accessorclass = SInvocation.getAccessorClass(iface, targetclass);
        T ret = null;
        if (accessorclass != null) {
            try {
                Constructor<T> c = accessorclass.getConstructor(null);
                ret = c.newInstance(null);
                Field f = accessorclass.getDeclaredField("delegate");
                f.set(ret, delegate);
            }
            catch (Exception e) {
                SUtil.throwUnchecked((Throwable)e);
            }
        } else {
            ret = SInvocation.createFallbackAccessor(iface, targetclass, delegate);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> Class<T> getAccessorClass(Class<T> iface, Class<?> targetclazz) {
        Class<T> ac = null;
        WeakKeyValueMap map = ACCESSOR_CLASSES.get(targetclazz);
        if (map != null) {
            ac = (Class<T>)map.get(iface);
        }
        if (!(ac != null || map != null && map.containsKey(iface))) {
            AtomicLong atomicLong = NAME_SUFFIX_COUNTER;
            synchronized (atomicLong) {
                map = ACCESSOR_CLASSES.get(targetclazz);
                if (map != null) {
                    ac = (Class)map.get(iface);
                }
                if (ac == null) {
                    if (map == null) {
                        map = new WeakKeyValueMap();
                    }
                    ClassLoader cl = targetclazz.getClassLoader();
                    IByteCodeClassLoader bcl = SASM.getByteCodeClassLoader(cl);
                    ac = SInvocation.createAccessorClass(bcl, iface, targetclazz);
                    map.put(iface, ac);
                    WeakHashMap newgenclasses = new WeakHashMap(ACCESSOR_CLASSES);
                    newgenclasses.put(targetclazz, map);
                    ACCESSOR_CLASSES = newgenclasses;
                }
            }
        }
        return ac;
    }

    public static final <T> Class<T> createAccessorClass(IByteCodeClassLoader cl, Class<T> iface, Class<?> clazz) {
        if (iface == null || !iface.isInterface()) {
            throw new IllegalArgumentException("Class is not an interface: " + iface);
        }
        Method[] ifacemethods = SReflect.getAllMethods(iface);
        int accesslevel = 1;
        Method[] targets = new Method[ifacemethods.length];
        for (int i = 0; i < ifacemethods.length; ++i) {
            Method[] cms = SReflect.getAllMethods(clazz, (String)ifacemethods[i].getName());
            Class[][] paramtypes = new Class[cms.length][];
            for (int j = 0; j < cms.length; ++j) {
                paramtypes[j] = cms[j].getParameterTypes();
            }
            int[] match = SReflect.matchArgumentTypes((Class[])ifacemethods[i].getParameterTypes(), (Class[][])paramtypes);
            if (match == null || match.length == 0) {
                throw new IllegalArgumentException("No match found for interface method " + ifacemethods[i]);
            }
            targets[i] = cms[match[0]];
            accesslevel = SInvocation.determineAccessLevel(accesslevel, targets[i].getModifiers());
        }
        String classname = SInvocation.class.getPackage().getName() + ".accessors.ClassAccessor_" + clazz.getName() + "_" + NAME_SUFFIX_COUNTER.incrementAndGet();
        ExtendedClassWriter cw = SInvocation.createClass(clazz, classname, accesslevel, iface);
        if (cw == null) {
            return null;
        }
        String internalname = cw.getInternalName();
        cw.visitField(1, "delegate", Type.getDescriptor(clazz), null, null);
        for (int i = 0; i < ifacemethods.length; ++i) {
            Method invmethod = ifacemethods[i];
            MethodVisitor mv = cw.visitMethod(1, invmethod.getName(), Type.getMethodDescriptor((Method)invmethod), null, null);
            mv.visitCode();
            if ((invmethod.getModifiers() & 8) == 0) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, internalname, "delegate", Type.getDescriptor(clazz));
            }
            int aload = 0;
            Class<?>[] paramtypes = targets[i].getParameterTypes();
            for (int j = 0; j < paramtypes.length; ++j) {
                if (Byte.TYPE.equals(paramtypes[j]) || Short.TYPE.equals(paramtypes[j]) || Character.TYPE.equals(paramtypes[j]) || Boolean.TYPE.equals(paramtypes[j]) || Integer.TYPE.equals(paramtypes[j])) {
                    mv.visitVarInsn(21, ++aload);
                    continue;
                }
                if (Long.TYPE.equals(paramtypes[j])) {
                    mv.visitVarInsn(22, ++aload);
                    ++aload;
                    continue;
                }
                if (Float.TYPE.equals(paramtypes[j])) {
                    mv.visitVarInsn(23, ++aload);
                    continue;
                }
                if (Double.TYPE.equals(paramtypes[j])) {
                    mv.visitVarInsn(24, ++aload);
                    ++aload;
                    continue;
                }
                mv.visitVarInsn(25, ++aload);
            }
            if ((targets[i].getModifiers() & 8) != 0) {
                mv.visitMethodInsn(184, Type.getInternalName(targets[i].getDeclaringClass()), targets[i].getName(), Type.getMethodDescriptor((Method)targets[i]), false);
            } else {
                mv.visitMethodInsn(182, Type.getInternalName(targets[i].getDeclaringClass()), targets[i].getName(), Type.getMethodDescriptor((Method)targets[i]), false);
            }
            InsnList insn = new InsnList();
            SASM.makeReturn(insn, Type.getType(invmethod.getReturnType()));
            insn.accept(mv);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        try {
            cw.visitEnd();
            byte[] classcode = cw.toByteArray();
            Class<?> genclass = null;
            genclass = cw.requiresParentLoader() ? cl.doDefineClassInParent(null, classcode, 0, classcode.length, clazz.getProtectionDomain()) : cl.doDefineClass(classcode);
            return genclass;
        }
        catch (Exception e) {
            throw SUtil.throwUnchecked((Throwable)e);
        }
    }

    public static final IExtractor newExtractor(Class<IExtractor> extractorclass) {
        try {
            System.out.println(extractorclass);
            Constructor<IExtractor> c = extractorclass.getConstructor(null);
            return c.newInstance(null);
        }
        catch (Exception e) {
            throw SUtil.throwUnchecked((Throwable)e);
        }
    }

    public static final Class<IExtractor> createExtractorClass(IByteCodeClassLoader cl, Class<?> clazz, String[] propnames, Member[] accessormember) {
        if (propnames.length != accessormember.length) {
            throw new IllegalArgumentException("Number of properties and methods must match.");
        }
        int accesslevel = 1;
        for (int i = 0; i < accessormember.length; ++i) {
            accesslevel = SInvocation.determineAccessLevel(accesslevel, accessormember[i].getModifiers());
        }
        String classnamesuffix = "ClassAccessor_" + clazz.getName() + "_" + NAME_SUFFIX_COUNTER.incrementAndGet();
        ExtendedClassWriter cw = SInvocation.createClass(clazz, classnamesuffix, accesslevel, IExtractor.class);
        String internalname = cw.getInternalName();
        cw.visitField(28, "PROPERTYNAMES", Type.getDescriptor(String[].class), null, null);
        MethodVisitor mv = cw.visitMethod(1, "<clinit>", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[0]), null, null);
        InsnList nl = new InsnList();
        SASM.pushImmediate(nl, propnames.length);
        nl.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(String.class)));
        for (int i = 0; i < propnames.length; ++i) {
            nl.add((AbstractInsnNode)new InsnNode(89));
            SASM.pushImmediate(nl, i);
            nl.add((AbstractInsnNode)new LdcInsnNode((Object)propnames[i]));
            nl.add((AbstractInsnNode)new InsnNode(83));
        }
        nl.add((AbstractInsnNode)new FieldInsnNode(179, internalname, "PROPERTYNAMES", Type.getDescriptor(String[].class)));
        nl.add((AbstractInsnNode)new InsnNode(177));
        nl.accept(mv);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        try {
            Method exmethod = IExtractor.class.getMethod("extract", Object.class);
            mv = cw.visitMethod(1, exmethod.getName(), Type.getMethodDescriptor((Method)exmethod), null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, Type.getInternalName(Tuple2.class));
            mv.visitInsn(89);
            mv.visitFieldInsn(178, internalname, "PROPERTYNAMES", Type.getDescriptor(String[].class));
            nl = new InsnList();
            SASM.pushImmediate(nl, propnames.length);
            nl.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Object.class)));
            for (int i = 0; i < propnames.length; ++i) {
                nl.add((AbstractInsnNode)new InsnNode(89));
                SASM.pushImmediate(nl, i);
                if (accessormember[i] instanceof Method) {
                    Method accessormethod = (Method)accessormember[i];
                    nl.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    nl.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(clazz)));
                    nl.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(accessormethod.getDeclaringClass()), accessormethod.getName(), Type.getMethodDescriptor((Method)accessormethod), false));
                } else if (accessormember[i] instanceof Field) {
                    Field accessorfield = (Field)accessormember[i];
                    nl.add((AbstractInsnNode)new FieldInsnNode(180, Type.getInternalName(accessorfield.getDeclaringClass()), accessorfield.getName(), Type.getDescriptor(accessorfield.getType())));
                } else {
                    throw new IllegalArgumentException("Illegal accessor member: " + accessormember[i]);
                }
                nl.add((AbstractInsnNode)new InsnNode(83));
            }
            nl.accept(mv);
            mv.visitMethodInsn(183, Type.getInternalName(Tuple2.class), "<init>", Type.getConstructorDescriptor(Tuple2.class.getConstructor(Object.class, Object.class)), false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        catch (Exception e) {
            SUtil.throwUnchecked((Throwable)e);
        }
        try {
            cw.visitEnd();
            byte[] classcode = cw.toByteArray();
            Class<IExtractor> genclass = null;
            genclass = cw.requiresParentLoader() ? cl.doDefineClassInParent(null, classcode, 0, classcode.length, clazz.getProtectionDomain()) : cl.doDefineClass(classcode);
            return genclass;
        }
        catch (Exception e) {
            throw SUtil.throwUnchecked((Throwable)e);
        }
    }

    protected static final ExtendedClassWriter createClass(Class<?> targetclass, String classname, int accesslevel, Class<?> ... interfaces) {
        if (!VmHacks.get().hasAsm()) {
            return null;
        }
        Class superclass = Object.class;
        Object genpackage = SInvocation.class.getPackage().getName() + ".generated";
        boolean needsparentcl = false;
        if (accesslevel == 2 || accesslevel != 1 && PRIVATE_ACCESS) {
            if (!PRIVATE_ACCESS) {
                return null;
            }
            try {
                Class<?> reffacclass = Class.forName("sun.reflect.ReflectionFactory");
                superclass = Class.forName("sun.reflect.MagicAccessorImpl", true, reffacclass.getClassLoader());
            }
            catch (Exception e) {
                return null;
            }
        } else if (accesslevel != 1) {
            if (!DEFAULT_ACCESS) {
                return null;
            }
            genpackage = targetclass.getPackage().getName();
            classname = (String)classname + "_" + Math.abs(SUtil.FAST_RANDOM.nextLong());
            needsparentcl = true;
        }
        String[] internalifaces = interfaces != null ? new String[interfaces.length] : new String[]{};
        for (int i = 0; i < internalifaces.length; ++i) {
            internalifaces[i] = Type.getType(interfaces[i]).getInternalName();
        }
        String internalname = ((String)genpackage + "." + (String)classname).replace('.', '/');
        ExtendedClassWriter cw = new ExtendedClassWriter(3, internalname, needsparentcl);
        cw.visit(50, 33, internalname, null, Type.getType(superclass).getInternalName(), internalifaces);
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        try {
            mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getConstructorDescriptor(Object.class.getConstructor(null)), false);
        }
        catch (Exception e) {
            return null;
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    protected static final void prepareParameters(MethodVisitor mv, Class<?>[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            mv.visitVarInsn(25, 2);
            InsnList nl = new InsnList();
            SASM.pushImmediate(nl, i);
            nl.accept(mv);
            mv.visitInsn(50);
            if (SReflect.isBasicType(parameters[i])) {
                Class cc = null;
                Method cm = null;
                try {
                    if (parameters[i].equals(Boolean.TYPE)) {
                        cc = Boolean.class;
                        cm = cc.getMethod("booleanValue", new Class[0]);
                    } else if (parameters[i].equals(Integer.TYPE)) {
                        cc = Integer.class;
                        cm = cc.getMethod("intValue", new Class[0]);
                    } else if (parameters[i].equals(Double.TYPE)) {
                        cc = Double.class;
                        cm = cc.getMethod("doubleValue", new Class[0]);
                    } else if (parameters[i].equals(Float.TYPE)) {
                        cc = Float.class;
                        cm = cc.getMethod("floatValue", new Class[0]);
                    } else if (parameters[i].equals(Long.TYPE)) {
                        cc = Long.class;
                        cm = cc.getMethod("longValue", new Class[0]);
                    } else if (parameters[i].equals(Short.TYPE)) {
                        cc = Short.class;
                        cm = cc.getMethod("shortValue", new Class[0]);
                    } else if (parameters[i].equals(Byte.TYPE)) {
                        cc = Byte.class;
                        cm = cc.getMethod("byteValue", new Class[0]);
                    } else if (parameters[i].equals(Character.TYPE)) {
                        cc = Character.class;
                        cm = cc.getMethod("charValue", new Class[0]);
                    }
                }
                catch (Exception e) {
                    SUtil.throwUnchecked((Throwable)e);
                }
                mv.visitTypeInsn(192, Type.getInternalName(cc));
                mv.visitMethodInsn(182, Type.getInternalName(cc), cm.getName(), Type.getMethodDescriptor((Method)cm), false);
                continue;
            }
            if (Object.class.equals(parameters[i])) continue;
            mv.visitTypeInsn(192, Type.getInternalName(parameters[i]));
        }
    }

    protected static final int determineAccessLevel(int currentlevel, int modifiers) {
        if ((modifiers & 1) == 0) {
            if ((modifiers & 2) != 0) {
                currentlevel = 2;
            } else if ((modifiers & 4) != 0 && currentlevel == 1) {
                currentlevel = 4;
            } else if (currentlevel == 1) {
                currentlevel = 0;
            }
        }
        return currentlevel;
    }

    protected static final <T> T createFallbackAccessor(final Class<T> iface, final Class<?> clazz, final Object obj) {
        InvocationHandler handler = new InvocationHandler(){
            protected Map<Method, IMethodInvoker> invocationmap = new HashMap<Method, IMethodInvoker>();
            {
                try {
                    Method[] methods;
                    for (Method method : methods = iface.getMethods()) {
                        Method cmethod = null;
                        for (Class cclazz = clazz; cmethod == null && cclazz != null; cclazz = cclazz.getSuperclass()) {
                            cmethod = cclazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                        }
                        SReflect.getMethod((Class)clazz, (String)method.getName(), (Class[])method.getParameterTypes());
                        this.invocationmap.put(method, SInvocation.newInvoker(cmethod));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                IMethodInvoker invoker = this.invocationmap.get(method);
                return invoker.invoke(obj, args);
            }
        };
        ClassLoader cl = clazz.getClassLoader();
        Object ret = Proxy.newProxyInstance(cl, new Class[]{iface}, handler);
        return (T)ret;
    }

    protected static final void enableEnhancedAccess() {
        AccessTestClass testobj = new AccessTestClass();
        DEFAULT_ACCESS = true;
        DEFAULT_ACCESS = SInvocation.hasMethodAccess("defaultTest", testobj);
        PRIVATE_ACCESS = true;
        PRIVATE_ACCESS = SInvocation.hasMethodAccess("privateTest", testobj);
    }

    private static final boolean hasMethodAccess(String testmethod, Object testobject) {
        IByteCodeClassLoader dummycl = SASM.createByteCodeClassLoader(null, AccessTestClass.class.getClassLoader());
        Method cicm = null;
        try {
            cicm = SInvocation.class.getDeclaredMethod("createInvokerClass", IByteCodeClassLoader.class, Method.class);
        }
        catch (Exception e) {
            return false;
        }
        SAccess.setAccessible((AccessibleObject)cicm, (boolean)true);
        boolean acc = false;
        try {
            Method m = testobject.getClass().getDeclaredMethod(testmethod, null);
            Class invclass = (Class)cicm.invoke(null, dummycl, m);
            if (invclass != null) {
                Constructor c = invclass.getConstructor(null);
                IMethodInvoker inv = (IMethodInvoker)c.newInstance(null);
                inv.invoke(testobject, null);
                acc = true;
            }
        }
        catch (Throwable t) {
            return false;
        }
        return acc;
    }

    static {
        VmHacks.get();
        SInvocation.enableEnhancedAccess();
    }

    public static class AccessTestClass {
        protected Object defaultTest() {
            return this.privateTest();
        }

        private Object privateTest() {
            return null;
        }
    }

    protected static class FallBackInvoker
    implements IMethodInvoker {
        protected Method method;

        public FallBackInvoker(Method method) {
            SAccess.setAccessible((AccessibleObject)method, (boolean)true);
            this.method = method;
        }

        @Override
        public Object invoke(Object object, Object ... args) {
            try {
                return this.method.invoke(object, args);
            }
            catch (Exception e) {
                throw SUtil.throwUnchecked((Throwable)e);
            }
        }
    }

    protected static class SortingInjectorWrapper
    implements IInjector {
        protected SortingInjectorWrapper() {
        }

        @Override
        public void inject(Object object, Object ... properties) {
            if (properties.length < 50) {
                for (int i = 0; i < properties.length; i += 2) {
                }
            }
        }
    }

    protected static class ExtendedClassWriter
    extends ClassWriter {
        protected String internalname;
        protected boolean requiresparentloader;

        public ExtendedClassWriter(int flags, String internalname, boolean requiresparentloader) {
            super(flags);
            this.internalname = internalname;
            this.requiresparentloader = requiresparentloader;
        }

        public String getInternalName() {
            return this.internalname;
        }

        public boolean requiresParentLoader() {
            return this.requiresparentloader;
        }
    }
}

