/*
 * Decompiled with CFR 0.152.
 */
package jadex.bytecode.access;

import jadex.bytecode.access.AccessAgent;
import jadex.commons.SUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InstAccess {
    protected static final File TEMP_JAR_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + ".jadex" + File.separator + "tmpjars");
    private static volatile MethodHandle setaccessible;
    private static byte[] preservedclass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final MethodHandle getAccessHandle() {
        if (setaccessible != null) return setaccessible;
        Class<InstAccess> clazz = InstAccess.class;
        synchronized (InstAccess.class) {
            if (setaccessible != null) return setaccessible;
            boolean started = false;
            try {
                Method sa = AccessibleObject.class.getDeclaredMethod("setAccessible0", Boolean.TYPE);
                InstAccess.startAgent();
                started = true;
                sa.setAccessible(true);
                setaccessible = MethodHandles.lookup().unreflect(sa);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (started) {
                    InstAccess.startAgent();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return setaccessible;
        }
    }

    private static final void startAgent() {
        File jar = null;
        try {
            Manifest man = new Manifest();
            Attributes attrs = man.getMainAttributes();
            attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attrs.put(new Attributes.Name("Premain-Class"), AccessAgent.class.getCanonicalName());
            attrs.put(new Attributes.Name("Agent-Class"), AccessAgent.class.getCanonicalName());
            attrs.put(new Attributes.Name("Main-Class"), AccessAgent.class.getCanonicalName());
            attrs.put(new Attributes.Name("Can-Redefine-Classes"), "true");
            attrs.put(new Attributes.Name("Can-Retransform-Classes"), "true");
            InputStream is = AccessAgent.class.getResourceAsStream(AccessAgent.class.getSimpleName() + ".class");
            jar = InstAccess.createTempJar(AccessAgent.class.getCanonicalName(), is, man);
            SUtil.close((Closeable)is);
            try {
                String pid = Long.toString(ProcessHandle.current().pid());
                Process p = null;
                try {
                    p = Runtime.getRuntime().exec(new String[]{"javaw", "-jar", jar.getAbsolutePath(), jar.getAbsolutePath(), pid});
                }
                catch (IOException e) {
                    p = Runtime.getRuntime().exec(new String[]{"java", "-jar", jar.getAbsolutePath(), jar.getAbsolutePath(), pid});
                }
                if (p != null) {
                    p.waitFor();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final byte[] enhanceClass(byte[] input) {
        if (preservedclass != null) {
            byte[] ret = preservedclass;
            preservedclass = null;
            return ret;
        }
        byte[] ret = null;
        ClassReader cr = new ClassReader(input);
        ClassNode cn = new ClassNode(589824);
        cr.accept((ClassVisitor)cn, 0);
        if (cn.name.equals(Method.class.getCanonicalName().replace(".", "/"))) {
            String methoddesc = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Boolean.TYPE)});
            MethodNode sanode = null;
            for (MethodNode mn : cn.methods) {
                if (!"setAccessible".equals(mn.name) || !methoddesc.equals(mn.desc)) continue;
                sanode = mn;
                break;
            }
            if (sanode != null) {
                InsnList list = sanode.instructions;
                list.clear();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(21, 1));
                list.add((AbstractInsnNode)new FieldInsnNode(181, Type.getInternalName(AccessibleObject.class), "override", Type.getDescriptor(Boolean.TYPE)));
                list.add((AbstractInsnNode)new InsnNode(177));
                ClassWriter cw = new ClassWriter(cr, 3);
                cn.accept((ClassVisitor)cw);
                ret = cw.toByteArray();
                preservedclass = input;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File createTempJar(String classname, InputStream classcontent, Manifest man) {
        if (!TEMP_JAR_DIR.exists()) {
            TEMP_JAR_DIR.mkdirs();
        }
        man = man == null ? new Manifest() : man;
        JarOutputStream os = null;
        File jar = null;
        try {
            jar = File.createTempFile("jadextmp", ".jar");
            jar = new File(TEMP_JAR_DIR, SUtil.createPlainRandomId((String)"tmpjar", (int)32) + ".jar");
            os = new JarOutputStream((OutputStream)new FileOutputStream(jar), man);
            String clname = classname.replace('.', '/') + ".class";
            JarEntry e = new JarEntry(clname);
            os.putNextEntry(e);
            SUtil.copyStream((InputStream)classcontent, (OutputStream)os);
            os.closeEntry();
            jar.deleteOnExit();
            if (os == null) return jar;
        }
        catch (Exception exception) {
            if (os == null) return jar;
            SUtil.close(os);
            return jar;
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                SUtil.close(os);
                throw throwable;
            }
        }
        SUtil.close((Closeable)os);
        return jar;
    }

    public static void main(String[] args) {
        try {
            Method sa = AccessibleObject.class.getDeclaredMethod("setAccessible0", Boolean.TYPE);
            InstAccess.getAccessHandle().invoke(sa, true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        SUtil.sleep((long)3000L);
    }
}

