/*
 * Decompiled with CFR 0.152.
 */
package jadex.bytecode;

import jadex.bytecode.ByteCodeClassLoader;
import jadex.bytecode.IByteCodeClassLoader;
import jadex.commons.SUtil;
import jadex.commons.collection.WeakKeyValueMap;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SASM {
    public static boolean SHARED_LOADERS_MODE = true;
    protected static final WeakKeyValueMap<ClassLoader, IByteCodeClassLoader> SHARED_CLASSLOADERS = new WeakKeyValueMap();

    public static void pushImmediate(InsnList nl, int immediate) {
        if (immediate >= -1 && immediate <= 5) {
            switch (immediate) {
                case -1: {
                    nl.add((AbstractInsnNode)new InsnNode(2));
                    break;
                }
                case 0: {
                    nl.add((AbstractInsnNode)new InsnNode(3));
                    break;
                }
                case 1: {
                    nl.add((AbstractInsnNode)new InsnNode(4));
                    break;
                }
                case 2: {
                    nl.add((AbstractInsnNode)new InsnNode(5));
                    break;
                }
                case 3: {
                    nl.add((AbstractInsnNode)new InsnNode(6));
                    break;
                }
                case 4: {
                    nl.add((AbstractInsnNode)new InsnNode(7));
                    break;
                }
                case 5: {
                    nl.add((AbstractInsnNode)new InsnNode(8));
                }
            }
        } else if (immediate <= 127 && immediate >= -128) {
            nl.add((AbstractInsnNode)new IntInsnNode(16, immediate));
        } else if (immediate <= Short.MAX_VALUE && immediate >= Short.MIN_VALUE) {
            nl.add((AbstractInsnNode)new IntInsnNode(17, immediate));
        } else {
            nl.add((AbstractInsnNode)new LdcInsnNode((Object)immediate));
        }
    }

    public static void pushImmediate(InsnList nl, long immediate) {
        if (immediate == 0L) {
            nl.add((AbstractInsnNode)new InsnNode(9));
        } else if (immediate == 1L) {
            nl.add((AbstractInsnNode)new InsnNode(10));
        } else if (immediate >= Integer.MIN_VALUE && immediate <= Integer.MAX_VALUE) {
            SASM.pushImmediate(nl, (int)immediate);
            nl.add((AbstractInsnNode)new InsnNode(133));
        } else {
            nl.add((AbstractInsnNode)new LdcInsnNode((Object)immediate));
        }
    }

    public static void makeObject(InsnList nl, Type type) {
        SASM.makeObject(nl, type, 1);
    }

    public static int makeObject(InsnList nl, Type arg, int pos) {
        if (arg.getClassName().equals("byte")) {
            nl.add((AbstractInsnNode)new VarInsnNode(21, pos++));
            nl.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false));
        } else if (arg.getClassName().equals("short")) {
            nl.add((AbstractInsnNode)new VarInsnNode(21, pos++));
            nl.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false));
        } else if (arg.getClassName().equals("int")) {
            nl.add((AbstractInsnNode)new VarInsnNode(21, pos++));
            nl.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false));
        } else if (arg.getClassName().equals("char")) {
            nl.add((AbstractInsnNode)new VarInsnNode(21, pos++));
            nl.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false));
        } else if (arg.getClassName().equals("boolean")) {
            nl.add((AbstractInsnNode)new VarInsnNode(21, pos++));
            nl.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false));
        } else if (arg.getClassName().equals("long")) {
            nl.add((AbstractInsnNode)new VarInsnNode(22, pos++));
            ++pos;
            nl.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false));
        } else if (arg.getClassName().equals("float")) {
            nl.add((AbstractInsnNode)new VarInsnNode(23, pos++));
            nl.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false));
        } else if (arg.getClassName().equals("double")) {
            nl.add((AbstractInsnNode)new VarInsnNode(24, pos++));
            ++pos;
            nl.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false));
        } else {
            nl.add((AbstractInsnNode)new VarInsnNode(25, pos++));
        }
        return pos;
    }

    public static void makeBasicType(InsnList nl, Type type) {
        if (type.getClassName().equals("byte")) {
            nl.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Boolean.class)));
            nl.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Byte", "byteValue", "()B", false));
        } else if (type.getClassName().equals("short")) {
            nl.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Short.class)));
            nl.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Short", "shortValue", "()S", false));
        } else if (type.getClassName().equals("int")) {
            nl.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Integer.class)));
            nl.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Integer", "intValue", "()I", false));
        } else if (type.getClassName().equals("char")) {
            nl.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Character.class)));
            nl.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Character", "charValue", "()C", false));
        } else if (type.getClassName().equals("boolean")) {
            nl.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Boolean.class)));
            nl.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
        } else if (type.getClassName().equals("long")) {
            nl.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Long.class)));
            nl.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Long", "longValue", "()J", false));
        } else if (type.getClassName().equals("float")) {
            nl.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Float.class)));
            nl.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Float", "floatValue", "()F", false));
        } else if (type.getClassName().equals("double")) {
            nl.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(Double.class)));
            nl.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Double", "doubleValue", "()D", false));
        }
    }

    public static void makeReturn(InsnList nl, Type type) {
        if (type.getClassName().equals("byte")) {
            nl.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.getClassName().equals("short")) {
            nl.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.getClassName().equals("int")) {
            nl.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.getClassName().equals("char")) {
            nl.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.getClassName().equals("boolean")) {
            nl.add((AbstractInsnNode)new InsnNode(172));
        } else if (type.getClassName().equals("long")) {
            nl.add((AbstractInsnNode)new InsnNode(173));
        } else if (type.getClassName().equals("float")) {
            nl.add((AbstractInsnNode)new InsnNode(174));
        } else if (type.getClassName().equals("double")) {
            nl.add((AbstractInsnNode)new InsnNode(175));
        } else if (Type.VOID_TYPE.equals((Object)type)) {
            nl.add((AbstractInsnNode)new InsnNode(177));
        } else {
            nl.add((AbstractInsnNode)new TypeInsnNode(192, type.getInternalName()));
            nl.add((AbstractInsnNode)new InsnNode(176));
        }
    }

    public static Class<?> toClass(String name, byte[] data, ClassLoader loader, ProtectionDomain domain) {
        Class<?> ret = null;
        IByteCodeClassLoader bcl = SASM.getByteCodeClassLoader(loader, true);
        try {
            ret = bcl.doDefineClassInParent(name, data, 0, data.length, domain);
        }
        catch (LinkageError e) {
            try {
                ret = bcl.loadClass(name);
            }
            catch (Exception e1) {
                SUtil.throwUnchecked((Throwable)e);
            }
        }
        return ret;
    }

    public static ClassNode getClassNode(Class<?> clazz, ClassLoader classloader) {
        ClassNode cns = null;
        try {
            cns = new ClassNode();
            ClassReader crs = new ClassReader(SUtil.getResource((String)(clazz.getName().replace(".", "/") + ".class"), (ClassLoader)classloader));
            crs.accept((ClassVisitor)cns, 0);
            return cns;
        }
        catch (Exception e) {
            SUtil.rethrowAsUnchecked((Throwable)e);
            return cns;
        }
    }

    public static IByteCodeClassLoader getByteCodeClassLoader(ClassLoader parent) {
        return SASM.getByteCodeClassLoader(parent, SHARED_LOADERS_MODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IByteCodeClassLoader getByteCodeClassLoader(ClassLoader parent, boolean sharedloaders) {
        IByteCodeClassLoader bcl = null;
        if (sharedloaders) {
            WeakKeyValueMap<ClassLoader, IByteCodeClassLoader> weakKeyValueMap = SHARED_CLASSLOADERS;
            synchronized (weakKeyValueMap) {
                bcl = (IByteCodeClassLoader)SHARED_CLASSLOADERS.get((Object)parent);
                if (bcl == null) {
                    bcl = SASM.createByteCodeClassLoader(parent, SASM.class.getClassLoader());
                    SHARED_CLASSLOADERS.put((Object)parent, (Object)bcl);
                }
            }
        } else {
            bcl = SASM.createByteCodeClassLoader(parent, SASM.class.getClassLoader());
        }
        return bcl;
    }

    public static final IByteCodeClassLoader createByteCodeClassLoader(ClassLoader ... parents) {
        return new ByteCodeClassLoader(parents);
    }
}

