/*
 * Decompiled with CFR 0.152.
 */
package jadex.bytecode;

import jadex.bytecode.SASM;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.collection.WeakValueMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceClassVisitor;

public class Proxy {
    public static final Set<String> OBJECTMETHODS = new HashSet<String>();
    public static final AtomicInteger COUNTER;
    public static final Map<Tuple2<ClassLoader, Set<Class<?>>>, Class<?>> CLASSCACHE;

    public static InvocationHandler getInvocationHandler(Object proxy) {
        try {
            proxy.getClass().getField("isproxy");
            Field f = proxy.getClass().getField("handler");
            return (InvocationHandler)f.get(proxy);
        }
        catch (Exception e) {
            SUtil.rethrowAsUnchecked((Throwable)e);
            return null;
        }
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] ifaces, InvocationHandler handler) {
        try {
            Class<?> clazz = null;
            ArrayList ifs = new ArrayList();
            for (Class<?> iface : ifaces) {
                if (!iface.isInterface()) {
                    clazz = iface;
                    continue;
                }
                ifs.add(iface);
            }
            Class[] ifsa = ifs.toArray(new Class[ifs.size()]);
            return Proxy.newProxyInstance(loader, clazz, ifsa, handler);
        }
        catch (Exception e) {
            SUtil.rethrowAsUnchecked((Throwable)e);
            return null;
        }
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?> clazz, Class<?>[] ifaces, InvocationHandler handler) {
        Set def = SUtil.arrayToSet(ifaces);
        if (clazz != null) {
            def.add(clazz);
        }
        loader = loader == null ? Proxy.class.getClassLoader() : loader;
        Tuple2 key = new Tuple2((Object)handler.getClass().getClassLoader(), (Object)def);
        Class<?> ret = CLASSCACHE.get(key);
        if (ret != null) {
            try {
                Constructor<?> c = ret.getConstructor(InvocationHandler.class);
                Object o = c.newInstance(handler);
                return o;
            }
            catch (Exception e) {
                SUtil.rethrowAsUnchecked((Throwable)e);
            }
        }
        ClassNode cn = new ClassNode();
        try {
            MethodNode nmn;
            Class[] allifs;
            ClassWriter cw = new ClassWriter(2);
            cn.version = 49;
            cn.access = 1;
            cn.name = (String)(clazz != null ? Type.getInternalName(clazz) + "Proxy" : "Proxy") + COUNTER.getAndIncrement();
            cn.superName = clazz != null ? Type.getInternalName(clazz) : Type.getType(Object.class).getInternalName();
            cn.fields.add(new FieldNode(1, "handler", "Ljava/lang/reflect/InvocationHandler;", null, null));
            cn.fields.add(new FieldNode(1, "isproxy", Type.getType(Boolean.class).getDescriptor(), null, (Object)Boolean.TRUE));
            Class[] classArray = allifs = ifaces != null ? SReflect.getSuperInterfaces((Class[])ifaces) : null;
            if (ifaces != null) {
                for (int i = 0; i < ifaces.length; ++i) {
                    cn.interfaces.add(Type.getInternalName(ifaces[i]));
                }
            }
            MethodNode mn = new MethodNode(1, "<init>", "(Ljava/lang/reflect/InvocationHandler;)V", null, null);
            mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            mn.instructions.add((AbstractInsnNode)new MethodInsnNode(183, clazz != null ? Type.getInternalName(clazz) : Type.getInternalName(Object.class), "<init>", "()V"));
            mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, cn.name, "handler", "Ljava/lang/reflect/InvocationHandler;"));
            mn.instructions.add((AbstractInsnNode)new InsnNode(177));
            cn.methods.add(mn);
            HashSet<CallSite> done = new HashSet<CallSite>();
            ClassNode cns = SASM.getClassNode(Object.class, loader);
            ArrayList ms = new ArrayList(cns.methods);
            for (MethodNode m : ms) {
                if (!OBJECTMETHODS.contains(m.name) || (nmn = Proxy.genrateInvocationCode(m, cn.name, null, loader)) == null || done.contains(nmn.name + nmn.desc)) continue;
                cn.methods.add(nmn);
                done.add((CallSite)((Object)(nmn.name + nmn.desc)));
            }
            if (clazz != null) {
                cns = SASM.getClassNode(clazz, loader);
                ms = new ArrayList(cns.methods);
                for (MethodNode m : ms) {
                    nmn = Proxy.genrateInvocationCode(m, cn.name, null, loader);
                    if (nmn == null || done.contains(nmn.name + nmn.desc)) continue;
                    cn.methods.add(nmn);
                    done.add((CallSite)((Object)(nmn.name + nmn.desc)));
                }
            }
            if (ifaces != null) {
                for (int i = 0; i < allifs.length; ++i) {
                    ClassNode tcn = SASM.getClassNode(allifs[i], loader);
                    List tms = tcn.methods;
                    for (MethodNode m : tms) {
                        MethodNode nmn2 = Proxy.genrateInvocationCode(m, cn.name, allifs[i], loader);
                        if (nmn2 == null || done.contains(nmn2.name + nmn2.desc)) continue;
                        cn.methods.add(nmn2);
                        done.add((CallSite)((Object)(nmn2.name + nmn2.desc)));
                    }
                }
            }
            cn.accept((ClassVisitor)cw);
            Class<?> cl = SASM.toClass(cn.name.replace("/", "."), cw.toByteArray(), new URLClassLoader(new URL[0], loader), null);
            Constructor<?> c = cl.getConstructor(InvocationHandler.class);
            Object o = c.newInstance(handler);
            CLASSCACHE.put(key, cl);
            return o;
        }
        catch (Throwable t) {
            ClassWriter cw = new ClassWriter(2);
            TraceClassVisitor tcv = new TraceClassVisitor((ClassVisitor)cw, (Printer)new ASMifier(), new PrintWriter(System.out));
            cn.accept((ClassVisitor)tcv);
            SUtil.rethrowAsUnchecked((Throwable)t);
            return null;
        }
    }

    protected static MethodNode genrateInvocationCode(MethodNode m, String classname, Class<?> iface, ClassLoader loader) throws Exception {
        MethodNode ret = null;
        if (!"<init>".equals(m.name) && !"<clinit>".equals(m.name)) {
            ret = new MethodNode(1, m.name, m.desc, m.signature, null);
            Type[] ptypes = Type.getArgumentTypes((String)ret.desc);
            ret.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            ret.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classname, "handler", Type.getDescriptor(InvocationHandler.class)));
            ret.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (iface == null) {
                ret.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                ret.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false));
                ret.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getSuperclass", "()Ljava/lang/Class;", false));
            } else {
                ret.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType(iface)));
            }
            ret.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)m.name));
            ret.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)ptypes.length));
            ret.instructions.add((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Class"));
            for (int i = 0; i < ptypes.length; ++i) {
                ret.instructions.add((AbstractInsnNode)new InsnNode(89));
                ret.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)i));
                Class cl = SReflect.findClass((String)ptypes[i].getClassName(), null, (ClassLoader)loader);
                if (cl.isPrimitive()) {
                    ret.instructions.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName((Class)SReflect.getWrappedType((Class)cl)), "TYPE", "Ljava/lang/Class;"));
                } else {
                    ret.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)ptypes[i]));
                }
                ret.instructions.add((AbstractInsnNode)new InsnNode(83));
            }
            ret.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false));
            ret.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)ptypes.length));
            ret.instructions.add((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
            int pos = 1;
            for (int i = 0; i < ptypes.length; ++i) {
                ret.instructions.add((AbstractInsnNode)new InsnNode(89));
                ret.instructions.add((AbstractInsnNode)new LdcInsnNode((Object)i));
                pos = SASM.makeObject(ret.instructions, ptypes[i], pos);
                ret.instructions.add((AbstractInsnNode)new InsnNode(83));
            }
            ret.instructions.add((AbstractInsnNode)new MethodInsnNode(185, "java/lang/reflect/InvocationHandler", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", true));
            Type rettype = Type.getReturnType((String)m.desc);
            if (Type.VOID_TYPE.equals((Object)rettype)) {
                ret.instructions.add((AbstractInsnNode)new InsnNode(87));
            }
            SASM.makeBasicType(ret.instructions, rettype);
            SASM.makeReturn(ret.instructions, rettype);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        ActionListener proxy2 = (ActionListener)Proxy.newProxyInstance(null, null, new Class[]{ActionListener.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                System.out.println("Handler called: " + proxy + " " + method + " " + args);
                return null;
            }
        });
        try {
            proxy2.actionPerformed(new ActionEvent(new Object(), 1, null));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static {
        OBJECTMETHODS.add("equals");
        OBJECTMETHODS.add("toString");
        OBJECTMETHODS.add("hashCode");
        COUNTER = new AtomicInteger();
        CLASSCACHE = Collections.synchronizedMap(new WeakValueMap());
    }
}

