/*
 * Decompiled with CFR 0.152.
 */
package jadex.bytecode;

import jadex.bytecode.IByteCodeClassLoader;
import jadex.bytecode.vmhacks.VmHacks;
import java.security.ProtectionDomain;

public class ByteCodeClassLoader
extends ClassLoader
implements IByteCodeClassLoader {
    protected ClassLoader[] delegates;

    public ByteCodeClassLoader(ClassLoader ... parents) {
        super(parents == null || parents.length == 0 ? null : parents[0]);
        this.addDelegates(parents);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> ret = null;
        if (this.delegates != null) {
            for (int i = 0; ret == null && i < this.delegates.length; ++i) {
                try {
                    ret = this.delegates[i].loadClass(name);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (ret == null) {
            throw new ClassNotFoundException(name);
        }
        return ret;
    }

    @Override
    public ClassLoader asClassLoader() {
        return this;
    }

    @Override
    public Class<?> doDefineClass(byte[] classcode) {
        Class<?> ret = this.doDefineClass(null, classcode, 0, classcode.length);
        return ret;
    }

    @Override
    public Class<?> doDefineClass(String name, byte[] b, int off, int len) {
        return this.defineClass(name, b, off, len);
    }

    @Override
    public Class<?> doDefineClass(String name, byte[] b, int off, int len, ProtectionDomain protectiondomain) {
        return this.defineClass(name, b, off, len, protectiondomain);
    }

    @Override
    public Class<?> doDefineClassInParent(String name, byte[] b, int off, int len, ProtectionDomain protectiondomain) {
        return VmHacks.get().defineClass(name, b, off, len, this.asClassLoader().getParent(), protectiondomain);
    }

    protected void addDelegates(ClassLoader[] parents) {
        if (parents != null && parents.length > 1) {
            this.delegates = new ClassLoader[parents.length - 1];
            System.arraycopy(parents, 1, this.delegates, 0, this.delegates.length);
        }
    }
}

