/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.quartz.impl.jdbcjobstore.DBSemaphore;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.Util;

public class StdRowLockSemaphore
extends DBSemaphore {
    public static final String SELECT_FOR_LOCK = "SELECT * FROM {0}LOCKS WHERE LOCK_NAME = ? FOR UPDATE";

    public StdRowLockSemaphore() {
        super("QRTZ_", null, SELECT_FOR_LOCK);
    }

    public StdRowLockSemaphore(String tablePrefix, String selectWithLockSQL) {
        super(tablePrefix, selectWithLockSQL, SELECT_FOR_LOCK);
    }

    protected void executeSQL(Connection conn, String lockName, String expandedSQL) throws LockException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(expandedSQL);
            ps.setString(1, lockName);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName()));
            }
            if (!(rs = ps.executeQuery()).next()) {
                throw new SQLException(Util.rtp("No row exists in table {0}LOCKS for lock named: " + lockName, this.getTablePrefix()));
            }
        }
        catch (SQLException sqle) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName()));
            }
            throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ignore) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    protected String getSelectWithLockSQL() {
        return this.getSQL();
    }

    public void setSelectWithLockSQL(String selectWithLockSQL) {
        this.setSQL(selectWithLockSQL);
    }
}

