/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.query;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import nz.co.gregs.dbvolution.columns.BooleanColumn;
import nz.co.gregs.dbvolution.columns.ColumnProvider;
import nz.co.gregs.dbvolution.columns.DateColumn;
import nz.co.gregs.dbvolution.columns.IntegerColumn;
import nz.co.gregs.dbvolution.columns.LargeObjectColumn;
import nz.co.gregs.dbvolution.columns.NumberColumn;
import nz.co.gregs.dbvolution.columns.StringColumn;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBInteger;
import nz.co.gregs.dbvolution.datatypes.DBLargeObject;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.IncorrectRowProviderInstanceSuppliedException;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.expressions.NumberExpression;
import nz.co.gregs.dbvolution.expressions.NumberResult;
import nz.co.gregs.dbvolution.expressions.StringExpression;
import nz.co.gregs.dbvolution.expressions.StringResult;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.internal.properties.RowDefinitionInstanceWrapper;
import nz.co.gregs.dbvolution.internal.properties.RowDefinitionWrapperFactory;

public class RowDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final RowDefinitionWrapperFactory wrapperFactory = new RowDefinitionWrapperFactory();
    private transient RowDefinitionInstanceWrapper wrapper = null;

    public PropertyWrapper getPropertyWrapperOf(Object qdt) {
        List<PropertyWrapper> props = this.getWrapper().getPropertyWrappers();
        for (PropertyWrapper prop : props) {
            Object qdtOfProp = prop.rawJavaValue();
            if (qdtOfProp != qdt) continue;
            return prop;
        }
        return null;
    }

    protected RowDefinitionInstanceWrapper getWrapper() {
        if (this.wrapper == null) {
            this.wrapper = wrapperFactory.instanceWrapperFor(this);
        }
        return this.wrapper;
    }

    public List<PropertyWrapper> getPropertyWrappers() {
        return this.getWrapper().getPropertyWrappers();
    }

    public LargeObjectColumn column(DBLargeObject fieldOfThisInstance) {
        return new LargeObjectColumn(this, fieldOfThisInstance);
    }

    public DBExpression column(QueryableDatatype fieldOfThisInstance) throws IncorrectRowProviderInstanceSuppliedException {
        ColumnProvider col = null;
        if (DBBoolean.class.isAssignableFrom(fieldOfThisInstance.getClass())) {
            col = this.column((DBBoolean)fieldOfThisInstance);
        } else if (DBDate.class.isAssignableFrom(fieldOfThisInstance.getClass())) {
            col = this.column((DBDate)fieldOfThisInstance);
        } else if (DBLargeObject.class.isAssignableFrom(fieldOfThisInstance.getClass())) {
            col = this.column((DBLargeObject)fieldOfThisInstance);
        } else if (DBInteger.class.isAssignableFrom(fieldOfThisInstance.getClass())) {
            col = this.column((DBInteger)fieldOfThisInstance);
        } else if (DBNumber.class.isAssignableFrom(fieldOfThisInstance.getClass())) {
            col = this.column((DBNumber)fieldOfThisInstance);
        } else if (DBString.class.isAssignableFrom(fieldOfThisInstance.getClass())) {
            col = this.column((DBString)fieldOfThisInstance);
        }
        if (col == null) {
            throw new IncorrectRowProviderInstanceSuppliedException(this, fieldOfThisInstance);
        }
        return col;
    }

    public BooleanColumn column(DBBoolean fieldOfThisInstance) {
        return new BooleanColumn(this, fieldOfThisInstance);
    }

    public BooleanColumn column(Boolean fieldOfThisInstance) {
        return new BooleanColumn(this, fieldOfThisInstance);
    }

    public StringColumn column(DBString fieldOfThisInstance) {
        return new StringColumn(this, fieldOfThisInstance);
    }

    public StringColumn column(String fieldOfThisInstance) {
        return new StringColumn(this, fieldOfThisInstance);
    }

    public StringExpression column(DBString fieldOfThisInstance, StringResult valueToUseIfDBNull) {
        return new StringColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public StringExpression column(DBString fieldOfThisInstance, String valueToUseIfDBNull) {
        return new StringColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public StringExpression column(String fieldOfThisInstance, StringResult valueToUseIfDBNull) {
        return new StringColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public StringExpression column(String fieldOfThisInstance, String valueToUseIfDBNull) {
        return new StringColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberColumn column(DBNumber fieldOfThisInstance) {
        return new NumberColumn(this, fieldOfThisInstance);
    }

    public NumberColumn column(Number fieldOfThisInstance) {
        return new NumberColumn(this, fieldOfThisInstance);
    }

    public NumberExpression column(Number fieldOfThisInstance, Number valueToUseIfDBNull) {
        return new NumberColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(DBNumber fieldOfThisInstance, Number valueToUseIfDBNull) {
        return new NumberColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(DBNumber fieldOfThisInstance, NumberResult valueToUseIfDBNull) {
        return new NumberColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public IntegerColumn column(DBInteger fieldOfThisInstance) {
        return new IntegerColumn(this, fieldOfThisInstance);
    }

    public IntegerColumn column(Long fieldOfThisInstance) {
        return new IntegerColumn(this, fieldOfThisInstance);
    }

    public IntegerColumn column(Integer fieldOfThisInstance) {
        return new IntegerColumn(this, fieldOfThisInstance);
    }

    public NumberExpression column(Integer fieldOfThisInstance, Integer valueToUseIfDBNull) {
        return new IntegerColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(Integer fieldOfThisInstance, Long valueToUseIfDBNull) {
        return new IntegerColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(Integer fieldOfThisInstance, NumberResult valueToUseIfDBNull) {
        return new IntegerColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(DBInteger fieldOfThisInstance, Integer valueToUseIfDBNull) {
        return new IntegerColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(DBInteger fieldOfThisInstance, Long valueToUseIfDBNull) {
        return new IntegerColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(DBInteger fieldOfThisInstance, NumberResult valueToUseIfDBNull) {
        return new IntegerColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(Long fieldOfThisInstance, Integer valueToUseIfDBNull) {
        return new IntegerColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(Long fieldOfThisInstance, Long valueToUseIfDBNull) {
        return new IntegerColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public NumberExpression column(Long fieldOfThisInstance, NumberResult valueToUseIfDBNull) {
        return new IntegerColumn(this, fieldOfThisInstance).ifDBNull(valueToUseIfDBNull);
    }

    public DateColumn column(DBDate fieldOfThisInstance) {
        return new DateColumn(this, fieldOfThisInstance);
    }

    public DateColumn column(Date fieldOfThisInstance) {
        return new DateColumn(this, fieldOfThisInstance);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        List<PropertyWrapper> fields = this.getWrapper().getPropertyWrappers();
        String separator = "" + this.getClass().getSimpleName();
        for (PropertyWrapper field : fields) {
            if (!field.isColumn()) continue;
            string.append(separator);
            string.append(" ");
            string.append(field.javaName());
            string.append(":");
            string.append(field.getQueryableDatatype());
            separator = ",";
        }
        return string.toString();
    }

    public String getHTMLTableRow(String tableRowCSSClass) {
        StringBuilder string = new StringBuilder();
        List<PropertyWrapper> fields = this.getWrapper().getPropertyWrappers();
        string.append("<tr class=\"").append(tableRowCSSClass).append("\">");
        for (PropertyWrapper field : fields) {
            if (!field.isColumn()) continue;
            string.append("<td>");
            string.append(((QueryableDatatype)field.getQueryableDatatype()).stringValue());
            string.append("</td>");
        }
        string.append("</tr>");
        return string.toString();
    }

    public String getHTMLTableHeader(String tableRowCSSClass, String tableHeaderCellCSSClass) {
        StringBuilder string = new StringBuilder();
        List<PropertyWrapper> fields = this.getWrapper().getPropertyWrappers();
        string.append("<tr class=\"").append(tableRowCSSClass).append("\">");
        for (PropertyWrapper field : fields) {
            if (!field.isColumn()) continue;
            string.append("<th class=\"").append(tableHeaderCellCSSClass).append("\">");
            string.append(field.javaName());
            string.append("</th>");
        }
        string.append("</tr>");
        return string.toString();
    }
}

