/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.query;

import java.util.HashSet;
import java.util.Set;
import nz.co.gregs.dbvolution.DBRow;

public class QueryGraphNode {
    private boolean requiredNode = true;
    private final Class<? extends DBRow> table;
    private final Set<Class<? extends DBRow>> connectedTables = new HashSet<Class<? extends DBRow>>();

    public QueryGraphNode(Class<? extends DBRow> table) {
        this.table = table;
    }

    public QueryGraphNode(Class<? extends DBRow> table, boolean requiredTable) {
        this.table = table;
        this.requiredNode = requiredTable;
    }

    private QueryGraphNode(QueryGraphNode value) {
        this.table = value.table;
        this.connectedTables.addAll(value.connectedTables);
    }

    public Set<Class<? extends DBRow>> getConnectedTables() {
        return this.connectedTables;
    }

    public void connectTable(Class<? extends DBRow> table) {
        this.connectedTables.add(table);
    }

    public Class<? extends DBRow> getTable() {
        return this.table;
    }

    public String toString() {
        return this.table.getSimpleName();
    }

    public boolean equals(Object o) {
        if (o instanceof QueryGraphNode) {
            QueryGraphNode otherNode = (QueryGraphNode)o;
            if (this.table.equals(otherNode.table)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.table != null ? this.table.hashCode() : 0);
        return hash;
    }

    public boolean isRequiredNode() {
        return this.requiredNode;
    }
}

