/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.query;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.expressions.BooleanExpression;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.query.QueryGraphNode;
import nz.co.gregs.dbvolution.query.QueryOptions;

public class QueryGraph {
    final Map<Class<? extends DBRow>, QueryGraphNode> nodes = new LinkedHashMap<Class<? extends DBRow>, QueryGraphNode>();
    final Map<Class<? extends DBRow>, DBRow> rows = new LinkedHashMap<Class<? extends DBRow>, DBRow>();
    Graph<QueryGraphNode, DBExpression> jungGraph = new SparseMultigraph();

    public QueryGraph(DBDatabase database, List<DBRow> allQueryTables, List<BooleanExpression> expressions, QueryOptions options) {
        this.addAndConnectToRelevant(database, allQueryTables, expressions, options);
    }

    public QueryGraph clear() {
        this.nodes.clear();
        this.rows.clear();
        this.clearDisplayGraph();
        return this;
    }

    public final void addAndConnectToRelevant(DBDatabase database, List<DBRow> otherTables, List<BooleanExpression> expressions, QueryOptions options) {
        this.addAndConnectToRelevant(database, otherTables, expressions, options, true);
    }

    public final void addOptionalAndConnectToRelevant(DBDatabase database, List<DBRow> otherTables, List<BooleanExpression> expressions, QueryOptions options) {
        this.addAndConnectToRelevant(database, otherTables, expressions, options, false);
    }

    public final void addAndConnectToRelevant(DBDatabase database, List<DBRow> otherTables, List<BooleanExpression> expressions, QueryOptions options, boolean requiredTables) {
        ArrayList<DBRow> tablesAdded = new ArrayList<DBRow>();
        ArrayList<DBRow> tablesRemaining = new ArrayList<DBRow>();
        tablesRemaining.addAll(this.rows.values());
        tablesRemaining.addAll(otherTables);
        this.clearDisplayGraph();
        while (tablesRemaining.size() > 0) {
            DBRow table1 = (DBRow)tablesRemaining.get(0);
            Class<?> table1Class = table1.getClass();
            QueryGraphNode node1 = this.getOrCreateNode(table1, table1Class, requiredTables);
            for (DBRow table2 : tablesAdded) {
                if (table1.getClass().equals(table2.getClass()) || !table1.willBeConnectedTo(database, table2, options)) continue;
                Class<?> table2Class = table2.getClass();
                QueryGraphNode node2 = this.getOrCreateNode(table2, table2Class, requiredTables);
                node1.connectTable(table2Class);
                node2.connectTable(table1Class);
                this.addEdgesToDisplayGraph(database, table1, node1, table2, node2, options);
            }
            tablesAdded.add(table1);
            tablesRemaining.remove(table1);
        }
        for (BooleanExpression expr : expressions) {
            Set<DBRow> tables = expr.getTablesInvolved();
            if (tables.size() <= 0) continue;
            DBRow table1 = tables.iterator().next();
            HashSet<DBRow> tablesToConnectTo = new HashSet<DBRow>(tables);
            tablesToConnectTo.remove(table1);
            Class<?> table1Class = table1.getClass();
            QueryGraphNode node1 = this.getOrCreateNode(table1, table1Class, requiredTables);
            this.addNodeToDisplayGraph(node1);
            for (DBRow table2 : tablesToConnectTo) {
                Class<?> table2Class = table2.getClass();
                QueryGraphNode node2 = this.getOrCreateNode(table2, table2Class, requiredTables);
                node1.connectTable(table2Class);
                node2.connectTable(table1Class);
                this.addNodeToDisplayGraph(node2);
                this.addEdgeToDisplayGraph(node1, node2, expr);
            }
        }
    }

    private QueryGraphNode getOrCreateNode(DBRow table1, Class<? extends DBRow> table1Class, boolean requiredTables) {
        QueryGraphNode node1 = this.nodes.get(table1Class);
        if (node1 == null) {
            node1 = new QueryGraphNode(table1Class, requiredTables);
            this.addNodeToDisplayGraph(node1);
            this.nodes.put(table1Class, node1);
            this.rows.put(table1Class, table1);
        }
        return node1;
    }

    private void addNodeToDisplayGraph(QueryGraphNode node1) {
        if (!this.jungGraph.containsVertex((Object)node1)) {
            this.jungGraph.addVertex((Object)node1);
        }
    }

    private void addEdgesToDisplayGraph(DBDatabase database, DBRow table1, QueryGraphNode node1, DBRow table2, QueryGraphNode node2, QueryOptions options) {
        for (BooleanExpression fk : table1.getRelationshipsAsBooleanExpressions(database, table2, options)) {
            if (this.jungGraph.containsEdge((Object)fk)) continue;
            this.jungGraph.addEdge((Object)fk, (Object)node1, (Object)node2);
        }
    }

    private void addEdgeToDisplayGraph(QueryGraphNode node1, QueryGraphNode node2, DBExpression fk) {
        if (!this.jungGraph.containsEdge((Object)fk)) {
            this.jungGraph.addEdge((Object)fk, (Object)node1, (Object)node2);
        }
    }

    public boolean willCreateCartesianJoin() {
        HashSet<DBRow> returnTables = new HashSet<DBRow>();
        returnTables.addAll(this.toList());
        for (DBRow row : this.rows.values()) {
            if (returnTables.contains(row)) continue;
            System.err.println("COULD NOT FIND TABLE: " + row.getClass().getSimpleName());
            return true;
        }
        return false;
    }

    private Class<? extends DBRow> getStartTable() {
        ArrayList<QueryGraphNode> innerNodes = new ArrayList<QueryGraphNode>();
        ArrayList<QueryGraphNode> outerNodes = new ArrayList<QueryGraphNode>();
        for (QueryGraphNode node : this.nodes.values()) {
            if (node.isRequiredNode()) {
                innerNodes.add(node);
                continue;
            }
            outerNodes.add(node);
        }
        ArrayList<QueryGraphNode> nodesToCheck = innerNodes;
        if (innerNodes.isEmpty()) {
            nodesToCheck = outerNodes;
        }
        for (QueryGraphNode queryGraphNode : nodesToCheck) {
            Class<? extends DBRow> tableClass = queryGraphNode.getTable();
            DBRow table = this.rows.get(tableClass);
            if (!table.hasConditionsSet()) continue;
            return tableClass;
        }
        return ((QueryGraphNode)nodesToCheck.get(0)).getTable();
    }

    public List<DBRow> toList() {
        return this.toList(this.getStartTable());
    }

    private List<DBRow> toList(Class<? extends DBRow> startFrom) {
        LinkedHashSet sortedInnerTables = new LinkedHashSet();
        LinkedHashSet<Class<DBRow>> sortedAllTables = new LinkedHashSet<Class<DBRow>>();
        ArrayList<Class<? extends DBRow>> addedInnerTables = new ArrayList<Class<? extends DBRow>>();
        ArrayList<Class<? extends DBRow>> addedAllTables = new ArrayList<Class<? extends DBRow>>();
        QueryGraphNode nodeA = this.nodes.get(startFrom);
        sortedAllTables.add(nodeA.getTable());
        int sortedAllBeforeLoop = 0;
        while (sortedAllTables.size() > sortedAllBeforeLoop) {
            sortedAllBeforeLoop = sortedAllTables.size();
            addedAllTables.clear();
            sortedInnerTables.addAll(sortedAllTables);
            int sortedInnerBeforeLoop = 0;
            while (sortedInnerTables.size() > sortedInnerBeforeLoop) {
                sortedInnerBeforeLoop = sortedInnerTables.size();
                addedInnerTables.clear();
                Class[] dummyArray = new Class[]{};
                Class[] sortedArray = sortedInnerTables.toArray(dummyArray);
                List<Class> reversedList = Arrays.asList(sortedArray);
                Collections.reverse(reversedList);
                for (Class row : reversedList) {
                    nodeA = this.nodes.get(row);
                    for (Class<? extends DBRow> table : nodeA.getConnectedTables()) {
                        QueryGraphNode nodeToAdd = this.nodes.get(table);
                        Class<? extends DBRow> nodeTable = nodeToAdd.getTable();
                        if (nodeToAdd.isRequiredNode()) {
                            addedInnerTables.add(nodeTable);
                        }
                        addedAllTables.add(nodeTable);
                    }
                }
                sortedInnerTables.addAll(addedInnerTables);
            }
            sortedAllTables.addAll(addedAllTables);
        }
        ArrayList<DBRow> returnTables = new ArrayList<DBRow>();
        for (Class rowClass : sortedInnerTables) {
            returnTables.add(this.rows.get(rowClass));
        }
        return returnTables;
    }

    public List<DBRow> toListIncludingCartesian() {
        HashSet<DBRow> returnTables = new HashSet<DBRow>();
        returnTables.addAll(this.toList());
        boolean changed = true;
        while (changed) {
            for (DBRow row : this.rows.values()) {
                changed = false;
                if (returnTables.contains(row)) continue;
                returnTables.addAll(this.toList(row.getClass()));
                changed = true;
            }
        }
        ArrayList<DBRow> returnList = new ArrayList<DBRow>();
        returnList.addAll(returnTables);
        return returnList;
    }

    public Graph<QueryGraphNode, DBExpression> getJungGraph() {
        return this.jungGraph;
    }

    private void clearDisplayGraph() {
        this.jungGraph = new SparseMultigraph();
    }
}

