/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import java.util.ArrayList;
import java.util.Collection;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.operators.DBEqualsOperator;
import nz.co.gregs.dbvolution.operators.DBInOperator;
import nz.co.gregs.dbvolution.operators.DBIsNullOperator;
import nz.co.gregs.dbvolution.operators.DBMetaOperator;

public class DBPermittedValuesOperator
extends DBMetaOperator {
    public static final long serialVersionUID = 1L;

    public DBPermittedValuesOperator(Object ... permitted) {
        ArrayList<QueryableDatatype> qdts = new ArrayList<QueryableDatatype>();
        int objectCount = 0;
        if (permitted == null) {
            this.operator = new DBIsNullOperator();
        } else {
            for (Object obj : permitted) {
                if (obj == null) {
                    this.includeNulls = true;
                    ++objectCount;
                    continue;
                }
                if (obj instanceof Collection) {
                    Collection myList = (Collection)obj;
                    for (Object obj1 : myList) {
                        qdts.add(QueryableDatatype.getQueryableDatatypeForObject(obj1));
                        ++objectCount;
                    }
                    continue;
                }
                qdts.add(QueryableDatatype.getQueryableDatatypeForObject(obj));
                ++objectCount;
            }
            this.operator = objectCount == 0 || qdts.isEmpty() ? new DBIsNullOperator() : (objectCount == 1 ? new DBEqualsOperator(qdts.get(0)) : new DBInOperator(qdts));
        }
        this.operator.includeNulls = this.includeNulls;
    }
}

