/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.expressions.StringExpression;
import nz.co.gregs.dbvolution.operators.DBOperator;

public class DBLikeOperator
extends DBOperator {
    public static final long serialVersionUID = 1L;

    public DBLikeOperator(String likeableValue) {
        this.firstValue = likeableValue == null ? null : new StringExpression(likeableValue);
    }

    public DBLikeOperator(DBExpression likeableValue) {
        this.firstValue = likeableValue == null ? likeableValue : likeableValue.copy();
    }

    public DBLikeOperator() {
        this.firstValue = null;
    }

    @Override
    public String generateWhereLine(DBDatabase db, String columnName) {
        DBDefinition defn = db.getDefinition();
        return "(" + defn.formatColumnName(columnName) + this.getOperator() + this.firstValue.toSQLString(db) + ")";
    }

    private String getOperator() {
        return this.invertOperator != false ? " not like " : " like ";
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        DBDefinition defn = database.getDefinition();
        return (this.invertOperator != false ? " not(" : "(") + defn.formatColumnName(columnName) + this.getOperator() + otherColumnName + ")";
    }

    @Override
    public DBOperator getInverseOperator() {
        return this;
    }

    @Override
    public DBLikeOperator copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        DBLikeOperator op = new DBLikeOperator(typeAdaptor.convert(this.firstValue));
        op.invertOperator = this.invertOperator;
        op.includeNulls = this.includeNulls;
        return op;
    }
}

