/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.operators.DBOperator;

public class DBLikeCaseInsensitiveOperator
extends DBOperator {
    public static final long serialVersionUID = 1L;

    public DBLikeCaseInsensitiveOperator(DBExpression likeableValue) {
        this.firstValue = likeableValue == null ? likeableValue : likeableValue.copy();
    }

    public DBLikeCaseInsensitiveOperator() {
        this.firstValue = null;
    }

    @Override
    public String generateWhereLine(DBDatabase db, String columnName) {
        if (db == null) {
            throw new RuntimeException("Database Cannot Be NULL: Please supply a proper DBDatabase instance.");
        }
        if (this.firstValue.toSQLString(db) == null) {
            throw new RuntimeException("Actual Comparison Is Required: please supply an actual object to compare against");
        }
        if (columnName == null) {
            throw new RuntimeException("MalFormed DBRow: please supply a column name using the DBColumn annotation");
        }
        if (this.invertOperator == null) {
            throw new RuntimeException("Invert Operator Missing: somehow you have removed the invertOperator instance, whatever you did with it, stop it.");
        }
        if (this.getOperator() == null) {
            throw new RuntimeException("Get Operator Returns NULL: the getOperator() method returned null when it should return a String of the database's operator.");
        }
        DBDefinition defn = db.getDefinition();
        return (this.invertOperator != false ? " not(" : "(") + defn.toLowerCase(defn.formatColumnName(columnName)) + this.getOperator() + " " + defn.toLowerCase(this.firstValue.toSQLString(db)) + ")";
    }

    private String getOperator() {
        return " like ";
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        DBDefinition defn = database.getDefinition();
        return (this.invertOperator != false ? " not(" : "(") + defn.toLowerCase(defn.formatColumnName(columnName)) + this.getOperator() + " " + defn.toLowerCase(otherColumnName) + ")";
    }

    @Override
    public DBOperator getInverseOperator() {
        return this;
    }

    @Override
    public DBLikeCaseInsensitiveOperator copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        DBLikeCaseInsensitiveOperator op = new DBLikeCaseInsensitiveOperator(typeAdaptor.convert(this.firstValue));
        op.invertOperator = this.invertOperator;
        op.includeNulls = this.includeNulls;
        return op;
    }
}

