/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.operators.DBGreaterThanOrEqualsOperator;
import nz.co.gregs.dbvolution.operators.DBOperator;

public class DBLessThanOperator
extends DBOperator {
    public static final long serialVersionUID = 1L;

    public DBLessThanOperator(DBExpression lessThanThis) {
        this.firstValue = lessThanThis != null ? lessThanThis.copy() : null;
    }

    public DBLessThanOperator() {
        this.firstValue = null;
    }

    public String getInverse() {
        return " >= ";
    }

    public String getOperator() {
        return " < ";
    }

    @Override
    public String generateWhereLine(DBDatabase db, String columnName) {
        return columnName + (this.invertOperator != false ? this.getInverse() : this.getOperator()) + this.firstValue.toSQLString(db) + " ";
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        return columnName + (this.invertOperator != false ? this.getInverse() : this.getOperator()) + otherColumnName;
    }

    @Override
    public DBOperator getInverseOperator() {
        return new DBGreaterThanOrEqualsOperator(this.firstValue);
    }

    @Override
    public DBLessThanOperator copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        DBLessThanOperator op = new DBLessThanOperator(typeAdaptor.convert(this.firstValue));
        op.invertOperator = this.invertOperator;
        op.includeNulls = this.includeNulls;
        return op;
    }
}

