/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.operators.DBIsNullOperator;
import nz.co.gregs.dbvolution.operators.DBOperator;

public class DBInOperator
extends DBOperator {
    public static final long serialVersionUID = 1L;
    protected final List<QueryableDatatype> listOfPossibleValues = new ArrayList<QueryableDatatype>();

    public DBInOperator(List<QueryableDatatype> listOfPossibleValues) {
        for (QueryableDatatype qdt : listOfPossibleValues) {
            this.listOfPossibleValues.add(qdt == null ? null : qdt.copy());
        }
    }

    public DBInOperator(Set<QueryableDatatype> listOfPossibleValues) {
        for (QueryableDatatype qdt : listOfPossibleValues) {
            this.listOfPossibleValues.add(qdt == null ? null : qdt.copy());
        }
    }

    public DBInOperator(QueryableDatatype[] listOfPossibleValues) {
        for (QueryableDatatype qdt : listOfPossibleValues) {
            this.listOfPossibleValues.add(qdt == null ? null : qdt.copy());
        }
    }

    public DBInOperator() {
    }

    @Override
    public String generateWhereLine(DBDatabase db, String columnName) {
        DBDefinition defn = db.getDefinition();
        StringBuilder whereClause = new StringBuilder();
        if (this.listOfPossibleValues.isEmpty()) {
            whereClause.append(defn.getFalseOperation());
        } else {
            whereClause.append(columnName);
            whereClause.append(this.invertOperator != false ? this.getInverse() : this.getOperator());
            String sep = "";
            for (QueryableDatatype qdt : this.listOfPossibleValues) {
                whereClause.append(sep).append(" ").append(qdt.toSQLString(db)).append(" ");
                sep = ",";
            }
            if (this.includeNulls.booleanValue()) {
                whereClause.append(sep).append(" ").append(defn.getEmptyString()).append(" ");
            }
            whereClause.append(")");
        }
        if (this.includeNulls.booleanValue()) {
            DBIsNullOperator dbIsNullOperator = new DBIsNullOperator();
            dbIsNullOperator.invertOperator(this.invertOperator);
            return "(" + dbIsNullOperator.generateWhereLine(db, columnName) + (this.invertOperator != false ? defn.beginAndLine() : defn.beginOrLine()) + whereClause.toString() + ")";
        }
        return whereClause.toString();
    }

    protected String getOperator() {
        return " in (";
    }

    protected String getInverse() {
        return " not in (";
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        return columnName + (this.invertOperator != false ? this.getInverse() : this.getOperator()) + otherColumnName + " ) ";
    }

    @Override
    public DBOperator getInverseOperator() {
        return this;
    }

    @Override
    public boolean equals(DBOperator other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other instanceof DBInOperator) {
            DBInOperator otherIn = (DBInOperator)other;
            if (this.listOfPossibleValues.size() != otherIn.listOfPossibleValues.size()) {
                return false;
            }
            for (QueryableDatatype qdt : this.listOfPossibleValues) {
                if (otherIn.listOfPossibleValues.contains(qdt)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public DBInOperator copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        ArrayList<QueryableDatatype> list = new ArrayList<QueryableDatatype>();
        for (QueryableDatatype item : this.listOfPossibleValues) {
            list.add((QueryableDatatype)typeAdaptor.convert(item));
        }
        DBInOperator op = new DBInOperator(list);
        op.invertOperator = this.invertOperator;
        op.includeNulls = this.includeNulls;
        return op;
    }
}

