/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.operators.DBInOperator;

public class DBInIgnoreCaseOperator
extends DBInOperator {
    public static final long serialVersionUID = 1L;

    public DBInIgnoreCaseOperator(List<QueryableDatatype> listOfPossibleValues) {
        super(listOfPossibleValues);
    }

    public DBInIgnoreCaseOperator() {
    }

    @Override
    public String generateWhereLine(DBDatabase db, String columnName) {
        DBDefinition defn = db.getDefinition();
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("");
        if (this.listOfPossibleValues.isEmpty()) {
            whereClause.append(defn.getFalseOperation());
        } else {
            whereClause.append(defn.toLowerCase(columnName));
            whereClause.append(this.invertOperator != false ? this.getInverse() : this.getOperator());
            String sep = "";
            for (QueryableDatatype qdt : this.listOfPossibleValues) {
                whereClause.append(sep).append(" ").append(qdt.toSQLString(db).toLowerCase()).append(" ");
                sep = ",";
            }
            whereClause.append(")");
        }
        return whereClause.toString();
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        DBDefinition defn = database.getDefinition();
        return defn.toLowerCase(columnName) + (this.invertOperator != false ? this.getInverse() : this.getOperator()) + defn.toLowerCase(otherColumnName) + " ) ";
    }

    @Override
    public DBInIgnoreCaseOperator copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        ArrayList<QueryableDatatype> list = new ArrayList<QueryableDatatype>();
        for (QueryableDatatype item : this.listOfPossibleValues) {
            list.add((QueryableDatatype)typeAdaptor.convert(item));
        }
        DBInIgnoreCaseOperator op = new DBInIgnoreCaseOperator(list);
        op.invertOperator = this.invertOperator;
        op.includeNulls = this.includeNulls;
        return op;
    }
}

