/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.operators.DBLessThanOrEqualOperator;
import nz.co.gregs.dbvolution.operators.DBOperator;

public class DBGreaterThanOperator
extends DBOperator {
    public static final long serialVersionUID = 1L;

    public DBGreaterThanOperator() {
        this.firstValue = null;
    }

    public DBGreaterThanOperator(DBExpression greaterThanThis) {
        this.firstValue = greaterThanThis == null ? greaterThanThis : greaterThanThis.copy();
    }

    public String getInverse() {
        return " <= ";
    }

    public String getOperator() {
        return " > ";
    }

    @Override
    public String generateWhereLine(DBDatabase db, String columnName) {
        DBDefinition defn = db.getDefinition();
        return columnName + (this.invertOperator != false ? this.getInverse() : this.getOperator()) + this.firstValue.toSQLString(db) + " ";
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        return columnName + (this.invertOperator != false ? this.getInverse() : this.getOperator()) + otherColumnName + " ";
    }

    @Override
    public DBOperator getInverseOperator() {
        return new DBLessThanOrEqualOperator(this.firstValue);
    }

    @Override
    public DBGreaterThanOperator copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        DBGreaterThanOperator op = new DBGreaterThanOperator(typeAdaptor.convert(this.firstValue));
        op.invertOperator = this.invertOperator;
        op.includeNulls = this.includeNulls;
        return op;
    }
}

