/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import java.sql.SQLException;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.DBTable;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.exceptions.InappropriateRelationshipOperator;
import nz.co.gregs.dbvolution.exceptions.IncorrectRowProviderInstanceSuppliedException;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.operators.DBOperator;
import nz.co.gregs.dbvolution.query.RowDefinition;

public class DBExistsOperator<E extends DBRow>
extends DBOperator {
    public static final long serialVersionUID = 1L;
    E tableRow;
    private final String referencedColumnName;

    public DBExistsOperator(E tableRow, Object qdtOfTheRow) throws IncorrectRowProviderInstanceSuppliedException {
        this.tableRow = DBRow.copyDBRow(tableRow);
        PropertyWrapper qdtField = ((RowDefinition)tableRow).getPropertyWrapperOf(qdtOfTheRow);
        if (qdtField == null) {
            throw new IncorrectRowProviderInstanceSuppliedException((RowDefinition)tableRow, qdtOfTheRow);
        }
        this.referencedColumnName = qdtField.columnName();
    }

    @Override
    public String generateWhereLine(DBDatabase database, String columnName) {
        DBDefinition defn = database.getDefinition();
        DBTable<E> table = DBTable.getInstance(database, this.tableRow);
        String subSelect = "";
        try {
            table.setRawSQL(defn.beginWhereClauseLine() + columnName + defn.getEqualsComparator() + defn.formatColumnName(this.referencedColumnName));
            subSelect = table.getSQLForQuery().replace(";", "");
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error In DBExistsOperator", ex);
        }
        return (this.invertOperator != false ? " not " : "") + " exists (" + subSelect + ") ";
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        throw new InappropriateRelationshipOperator(this);
    }

    @Override
    public DBOperator getInverseOperator() {
        throw new InappropriateRelationshipOperator(this);
    }

    @Override
    public DBExistsOperator<E> copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        return this;
    }
}

