/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.operators.DBIsNullOperator;
import nz.co.gregs.dbvolution.operators.DBOperator;

public class DBEqualsOperator
extends DBOperator {
    public static final long serialVersionUID = 1L;

    public DBEqualsOperator() {
    }

    public DBEqualsOperator(DBExpression equalTo) {
        this.firstValue = equalTo == null ? equalTo : equalTo.copy();
    }

    public DBEqualsOperator(Object equalTo) {
        QueryableDatatype first = QueryableDatatype.getQueryableDatatypeForObject(equalTo);
        this.firstValue = first == null ? first : first.copy();
    }

    public String getInverse(DBDefinition defn) {
        if (defn != null) {
            return defn.getNotEqualsComparator();
        }
        return " <> ";
    }

    public String getOperator(DBDefinition defn) {
        if (defn != null) {
            return defn.getEqualsComparator();
        }
        return " = ";
    }

    @Override
    public String generateWhereLine(DBDatabase db, String columnName) {
        String whereLine;
        DBIsNullOperator dbIsNullOperator;
        DBDefinition defn = db.getDefinition();
        if (this.firstValue instanceof QueryableDatatype && ((QueryableDatatype)this.firstValue).isNull()) {
            dbIsNullOperator = new DBIsNullOperator();
            dbIsNullOperator.invertOperator(this.invertOperator);
            whereLine = dbIsNullOperator.generateWhereLine(db, columnName);
        } else {
            whereLine = columnName + (this.invertOperator != false ? this.getInverse(defn) : this.getOperator(defn)) + this.firstValue.toSQLString(db);
        }
        if (this.includeNulls.booleanValue()) {
            dbIsNullOperator = new DBIsNullOperator();
            dbIsNullOperator.invertOperator(this.invertOperator);
            return "(" + dbIsNullOperator.generateWhereLine(db, columnName) + (this.invertOperator != false ? defn.beginAndLine() : defn.beginOrLine()) + whereLine + ")";
        }
        return whereLine;
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        DBDefinition defn = database.getDefinition();
        String relationStr = columnName + (this.invertOperator != false ? this.getInverse(defn) : this.getOperator(defn)) + otherColumnName;
        return relationStr;
    }

    @Override
    public DBOperator getInverseOperator() {
        return this;
    }

    @Override
    public DBEqualsOperator copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        DBEqualsOperator op = new DBEqualsOperator(typeAdaptor.convert(this.firstValue));
        op.invertOperator = this.invertOperator;
        op.includeNulls = this.includeNulls;
        return op;
    }
}

