/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.operators.DBEqualsOperator;
import nz.co.gregs.dbvolution.operators.DBIsNullOperator;

public class DBEqualsIgnoreCaseOperator
extends DBEqualsOperator {
    public static final long serialVersionUID = 1L;

    public DBEqualsIgnoreCaseOperator() {
    }

    public DBEqualsIgnoreCaseOperator(DBExpression equalTo) {
        super(equalTo);
    }

    @Override
    public String generateWhereLine(DBDatabase db, String columnName) {
        DBDefinition defn = db.getDefinition();
        if (this.firstValue.toSQLString(db).equals(defn.getNull())) {
            DBIsNullOperator dbIsNullOperator = new DBIsNullOperator();
            return dbIsNullOperator.generateWhereLine(db, columnName);
        }
        return defn.toLowerCase(columnName) + (this.invertOperator != false ? this.getInverse(defn) : this.getOperator(defn)) + defn.toLowerCase(this.firstValue.toSQLString(db)) + " ";
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        DBDefinition defn = database.getDefinition();
        return defn.toLowerCase(columnName) + (this.invertOperator != false ? this.getInverse(defn) : this.getOperator(defn)) + defn.toLowerCase(otherColumnName);
    }

    @Override
    public DBEqualsIgnoreCaseOperator copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        DBEqualsIgnoreCaseOperator op = new DBEqualsIgnoreCaseOperator(typeAdaptor.convert(this.firstValue));
        op.invertOperator = this.invertOperator;
        op.includeNulls = this.includeNulls;
        return op;
    }
}

