/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.operators;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.exceptions.InappropriateRelationshipOperator;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.operators.DBBetweenOperator;
import nz.co.gregs.dbvolution.operators.DBOperator;

public class DBBetweenExclusiveOperator
extends DBOperator {
    public static final long serialVersionUID = 1L;

    public DBBetweenExclusiveOperator(DBExpression lowValue, DBExpression highValue) {
        this.firstValue = lowValue == null ? lowValue : lowValue.copy();
        this.secondValue = highValue == null ? highValue : highValue.copy();
    }

    @Override
    public String generateWhereLine(DBDatabase db, String columnName) {
        String lowerSQLValue = this.firstValue.toSQLString(db);
        String upperSQLValue = this.secondValue.toSQLString(db);
        String beginWhereLine = "";
        return beginWhereLine + (this.invertOperator != false ? " not(" : "(") + columnName + " > " + lowerSQLValue + " and " + columnName + " < " + upperSQLValue + ")";
    }

    @Override
    public String generateRelationship(DBDatabase database, String columnName, String otherColumnName) {
        throw new InappropriateRelationshipOperator(this);
    }

    @Override
    public DBOperator getInverseOperator() {
        throw new InappropriateRelationshipOperator(this);
    }

    @Override
    public DBBetweenOperator copyAndAdapt(QueryableDatatypeSyncer.DBSafeInternalQDTAdaptor typeAdaptor) {
        DBBetweenOperator op = new DBBetweenOperator(typeAdaptor.convert(this.firstValue), typeAdaptor.convert(this.secondValue));
        op.invertOperator = this.invertOperator;
        op.includeNulls = this.includeNulls;
        return op;
    }
}

