/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.annotations.DBTableName;

class TableHandler {
    private final boolean isTable;
    private final String tableName;
    private final DBTableName tableNameAnnotation;

    public TableHandler(Class<?> adaptee) {
        String name;
        this.tableNameAnnotation = adaptee.getAnnotation(DBTableName.class);
        this.isTable = DBRow.class.isAssignableFrom(adaptee);
        String explicitName = null;
        if (this.tableNameAnnotation != null && (name = this.tableNameAnnotation.value()) != null && !name.trim().equals("")) {
            explicitName = name;
        }
        this.tableName = explicitName == null ? adaptee.getSimpleName() : explicitName;
    }

    public boolean isTable() {
        return this.isTable;
    }

    public String getTableName() {
        return this.isTable ? this.tableName : null;
    }

    public DBTableName getDBTableNameAnnotation() {
        return this.tableNameAnnotation;
    }
}

